///////////////////////////////////////////////////////////////////////////////////
// File: mc56f8006.h
// Purpose: Define the peripheral registers for MC56F8006 devices.
// This file has been automatically generated from the device specification.
///////////////////////////////////////////////////////////////////////////////////
#ifndef __56f8006_h
#define __56f8006_h
#include "cpu.h"

#ifndef __CPU_H
typedef unsigned short int      uint16_t;
typedef volatile uint16_t       vuint16_t;
#endif __CPU_H
///////////////////////////////////////////////////////////////////////////////////
// There are two styles of register and bit field declarations defined.
// in this file.  They may be used interchangeably.
// The first consist of simple defines for both register locations
// and bit field masks. 
// The second utilizes structure definitions to define each register
// in terms of its bit fields.  That structure is then used to create
// a pointer to the actual register location.  The pointer can be used
// to access individual register bit fields.
//
// Usage:
// Type 1: REGISTER_NAME = value;
//         value = REGISTER_NAME;
// Type 2: sREGISTER_NAME.BIT_FIELD_NAME = value;
//         value = sREGISTER_NAME.BIT_FIELD_NAME;
///////////////////////////////////////////////////////////////////////////////////
// Begin Type 1 Register definitions.
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
// Define TMR0 Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	TMR0_COMP1      	(*(vuint16_t *) (0x00F000)) 	// TMR0
#define 	TMR0_COMP2      	(*(vuint16_t *) (0x00F001)) 	// TMR0
#define 	TMR0_CAPT       	(*(vuint16_t *) (0x00F002)) 	// TMR0
#define 	TMR0_LOAD       	(*(vuint16_t *) (0x00F003)) 	// TMR0
#define 	TMR0_HOLD       	(*(vuint16_t *) (0x00F004)) 	// TMR0
#define 	TMR0_CNTR       	(*(vuint16_t *) (0x00F005)) 	// TMR0
#define 	TMR0_CTRL       	(*(vuint16_t *) (0x00F006)) 	// TMR0
#define 	TMR0_SCTRL      	(*(vuint16_t *) (0x00F007)) 	// TMR0
#define 	TMR0_CMPLD1     	(*(vuint16_t *) (0x00F008)) 	// TMR0
#define 	TMR0_CMPLD2     	(*(vuint16_t *) (0x00F009)) 	// TMR0
#define 	TMR0_CSCTRL     	(*(vuint16_t *) (0x00F00A)) 	// TMR0
#define 	TMR0_FILT       	(*(vuint16_t *) (0x00F00B)) 	// TMR0
#define 	TMR_ENBL        	(*(vuint16_t *) (0x00F00F)) 	// TMR0

///////////////////////////////////////////////////////////////////////////////////
// Define TMR1 Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	TMR1_COMP1      	(*(vuint16_t *) (0x00F010)) 	// TMR1
#define 	TMR1_COMP2      	(*(vuint16_t *) (0x00F011)) 	// TMR1
#define 	TMR1_CAPT       	(*(vuint16_t *) (0x00F012)) 	// TMR1
#define 	TMR1_LOAD       	(*(vuint16_t *) (0x00F013)) 	// TMR1
#define 	TMR1_HOLD       	(*(vuint16_t *) (0x00F014)) 	// TMR1
#define 	TMR1_CNTR       	(*(vuint16_t *) (0x00F015)) 	// TMR1
#define 	TMR1_CTRL       	(*(vuint16_t *) (0x00F016)) 	// TMR1
#define 	TMR1_SCTRL      	(*(vuint16_t *) (0x00F017)) 	// TMR1
#define 	TMR1_CMPLD1     	(*(vuint16_t *) (0x00F018)) 	// TMR1
#define 	TMR1_CMPLD2     	(*(vuint16_t *) (0x00F019)) 	// TMR1
#define 	TMR1_CSCTRL     	(*(vuint16_t *) (0x00F01A)) 	// TMR1
#define 	TMR1_FILT       	(*(vuint16_t *) (0x00F01B)) 	// TMR1

///////////////////////////////////////////////////////////////////////////////////
// Define PWM Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	PWM_CTRL        	(*(vuint16_t *) (0x00F020)) 	// PWM
#define 	PWM_FCTRL       	(*(vuint16_t *) (0x00F021)) 	// PWM
#define 	PWM_FLTACK      	(*(vuint16_t *) (0x00F022)) 	// PWM
#define 	PWM_OUT         	(*(vuint16_t *) (0x00F023)) 	// PWM
#define 	PWM_CNTR        	(*(vuint16_t *) (0x00F024)) 	// PWM
#define 	PWM_CMOD        	(*(vuint16_t *) (0x00F025)) 	// PWM
#define 	PWM_VAL0        	(*(vuint16_t *) (0x00F026)) 	// PWM
#define 	PWM_VAL1        	(*(vuint16_t *) (0x00F027)) 	// PWM
#define 	PWM_VAL2        	(*(vuint16_t *) (0x00F028)) 	// PWM
#define 	PWM_VAL3        	(*(vuint16_t *) (0x00F029)) 	// PWM
#define 	PWM_VAL4        	(*(vuint16_t *) (0x00F02A)) 	// PWM
#define 	PWM_VAL5        	(*(vuint16_t *) (0x00F02B)) 	// PWM
#define 	PWM_DTIM0       	(*(vuint16_t *) (0x00F02C)) 	// PWM
#define 	PWM_DTIM1       	(*(vuint16_t *) (0x00F02D)) 	// PWM
#define 	PWM_DMAP1       	(*(vuint16_t *) (0x00F02E)) 	// PWM
#define 	PWM_DMAP2       	(*(vuint16_t *) (0x00F02F)) 	// PWM
#define 	PWM_CNFG        	(*(vuint16_t *) (0x00F030)) 	// PWM
#define 	PWM_CCTRL       	(*(vuint16_t *) (0x00F031)) 	// PWM
#define 	PWM_PORT        	(*(vuint16_t *) (0x00F032)) 	// PWM
#define 	PWM_ICCTRL      	(*(vuint16_t *) (0x00F033)) 	// PWM
#define 	PWM_SCTRL       	(*(vuint16_t *) (0x00F034)) 	// PWM
#define 	PWM_SYNC        	(*(vuint16_t *) (0x00F035)) 	// PWM
#define 	PWM_FFILT0      	(*(vuint16_t *) (0x00F036)) 	// PWM
#define 	PWM_FFILT1      	(*(vuint16_t *) (0x00F037)) 	// PWM
#define 	PWM_FFILT2      	(*(vuint16_t *) (0x00F038)) 	// PWM
#define 	PWM_FFILT3      	(*(vuint16_t *) (0x00F039)) 	// PWM

///////////////////////////////////////////////////////////////////////////////////
// Define INTC Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	INTC_ICSR       	(*(vuint16_t *) (0x00F040)) 	// INTC
#define 	INTC_VBA        	(*(vuint16_t *) (0x00F041)) 	// INTC
#define 	INTC_IAR0       	(*(vuint16_t *) (0x00F042)) 	// INTC
#define 	INTC_IAR1       	(*(vuint16_t *) (0x00F043)) 	// INTC
#define 	INTC_IAR2       	(*(vuint16_t *) (0x00F044)) 	// INTC

///////////////////////////////////////////////////////////////////////////////////
// Define ADC0 Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	ADC0_ADCSC1A    	(*(vuint16_t *) (0x00F060)) 	// ADC0
#define 	ADC0_ADCSC2     	(*(vuint16_t *) (0x00F061)) 	// ADC0
#define 	ADC0_ADCCFG     	(*(vuint16_t *) (0x00F066)) 	// ADC0
#define 	ADC0_ADCSC1B    	(*(vuint16_t *) (0x00F06A)) 	// ADC0
#define 	ADC0_ADCRA      	(*(vuint16_t *) (0x00F06B)) 	// ADC0
#define 	ADC0_ADCRB      	(*(vuint16_t *) (0x00F06C)) 	// ADC0

///////////////////////////////////////////////////////////////////////////////////
// Define ADC1 Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	ADC1_ADCSC1A    	(*(vuint16_t *) (0x00F080)) 	// ADC1
#define 	ADC1_ADCSC2     	(*(vuint16_t *) (0x00F081)) 	// ADC1
#define 	ADC1_ADCCFG     	(*(vuint16_t *) (0x00F086)) 	// ADC1
#define 	ADC1_ADCSC1B    	(*(vuint16_t *) (0x00F08A)) 	// ADC1
#define 	ADC1_ADCRA      	(*(vuint16_t *) (0x00F08B)) 	// ADC1
#define 	ADC1_ADCRB      	(*(vuint16_t *) (0x00F08C)) 	// ADC1

///////////////////////////////////////////////////////////////////////////////////
// Define PGA0 Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	PGA0_CNTL0      	(*(vuint16_t *) (0x00F0A0)) 	// PGA0
#define 	PGA0_CNTL1      	(*(vuint16_t *) (0x00F0A1)) 	// PGA0
#define 	PGA0_CNTL2      	(*(vuint16_t *) (0x00F0A2)) 	// PGA0
#define 	PGA0_STS        	(*(vuint16_t *) (0x00F0A3)) 	// PGA0

///////////////////////////////////////////////////////////////////////////////////
// Define PGA1 Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	PGA1_CNTL0      	(*(vuint16_t *) (0x00F0C0)) 	// PGA1
#define 	PGA1_CNTL1      	(*(vuint16_t *) (0x00F0C1)) 	// PGA1
#define 	PGA1_CNTL2      	(*(vuint16_t *) (0x00F0C2)) 	// PGA1
#define 	PGA1_STS        	(*(vuint16_t *) (0x00F0C3)) 	// PGA1

///////////////////////////////////////////////////////////////////////////////////
// Define SCI Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	SCI_RATE        	(*(vuint16_t *) (0x00F0E0)) 	// SCI
#define 	SCI_CTRL1       	(*(vuint16_t *) (0x00F0E1)) 	// SCI
#define 	SCI_CTRL2       	(*(vuint16_t *) (0x00F0E2)) 	// SCI
#define 	SCI_STAT        	(*(vuint16_t *) (0x00F0E3)) 	// SCI
#define 	SCI_DATA        	(*(vuint16_t *) (0x00F0E4)) 	// SCI

///////////////////////////////////////////////////////////////////////////////////
// Define SPI Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	SPI_SCTRL       	(*(vuint16_t *) (0x00F100)) 	// SPI
#define 	SPI_DSCTRL      	(*(vuint16_t *) (0x00F101)) 	// SPI
#define 	SPI_DRCV        	(*(vuint16_t *) (0x00F102)) 	// SPI
#define 	SPI_DXMIT       	(*(vuint16_t *) (0x00F103)) 	// SPI

///////////////////////////////////////////////////////////////////////////////////
// Define I2C Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	I2C_ADDR        	(*(vuint16_t *) (0x00F120)) 	// I2C
#define 	I2C_FREQDIV     	(*(vuint16_t *) (0x00F121)) 	// I2C
#define 	I2C_CR1         	(*(vuint16_t *) (0x00F122)) 	// I2C
#define 	I2C_SR          	(*(vuint16_t *) (0x00F123)) 	// I2C
#define 	I2C_DATA        	(*(vuint16_t *) (0x00F124)) 	// I2C
#define 	I2C_CR2         	(*(vuint16_t *) (0x00F125)) 	// I2C
#define 	I2C_SMB_CSR     	(*(vuint16_t *) (0x00F126)) 	// I2C
#define 	I2C_ADDR2       	(*(vuint16_t *) (0x00F127)) 	// I2C
#define 	I2C_SLT1        	(*(vuint16_t *) (0x00F128)) 	// I2C
#define 	I2C_SLT2        	(*(vuint16_t *) (0x00F129)) 	// I2C

///////////////////////////////////////////////////////////////////////////////////
// Define COP Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	COP_CTRL        	(*(vuint16_t *) (0x00F140)) 	// COP
#define 	COP_TOUT        	(*(vuint16_t *) (0x00F141)) 	// COP
#define 	COP_CNTR        	(*(vuint16_t *) (0x00F142)) 	// COP

///////////////////////////////////////////////////////////////////////////////////
// Define OCCS Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	OCCS_CTRL       	(*(vuint16_t *) (0x00F160)) 	// OCCS
#define 	OCCS_DIVBY      	(*(vuint16_t *) (0x00F161)) 	// OCCS
#define 	OCCS_STAT       	(*(vuint16_t *) (0x00F162)) 	// OCCS
#define 	OCCS_TESTR      	(*(vuint16_t *) (0x00F163)) 	// OCCS
#define 	OCCS_OCTRL      	(*(vuint16_t *) (0x00F164)) 	// OCCS
#define 	OCCS_CLKCHKR    	(*(vuint16_t *) (0x00F165)) 	// OCCS
#define 	OCCS_CLKCHKT    	(*(vuint16_t *) (0x00F166)) 	// OCCS
#define 	OCCS_PROT       	(*(vuint16_t *) (0x00F167)) 	// OCCS

///////////////////////////////////////////////////////////////////////////////////
// Define GPIOA Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	GPIOA_PUR       	(*(vuint16_t *) (0x00F180)) 	// GPIOA
#define 	GPIOA_DR        	(*(vuint16_t *) (0x00F181)) 	// GPIOA
#define 	GPIOA_DDR       	(*(vuint16_t *) (0x00F182)) 	// GPIOA
#define 	GPIOA_PER       	(*(vuint16_t *) (0x00F183)) 	// GPIOA
#define 	GPIOA_IENR      	(*(vuint16_t *) (0x00F185)) 	// GPIOA
#define 	GPIOA_IPOLR     	(*(vuint16_t *) (0x00F186)) 	// GPIOA
#define 	GPIOA_IPR       	(*(vuint16_t *) (0x00F187)) 	// GPIOA
#define 	GPIOA_IESR      	(*(vuint16_t *) (0x00F188)) 	// GPIOA
#define 	GPIOA_RAWDATA   	(*(vuint16_t *) (0x00F18A)) 	// GPIOA
#define 	GPIOA_DRIVE     	(*(vuint16_t *) (0x00F18B)) 	// GPIOA
#define 	GPIOA_IFE       	(*(vuint16_t *) (0x00F18C)) 	// GPIOA
#define 	GPIOA_SLEW      	(*(vuint16_t *) (0x00F18D)) 	// GPIOA

///////////////////////////////////////////////////////////////////////////////////
// Define GPIOB Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	GPIOB_PUR       	(*(vuint16_t *) (0x00F1A0)) 	// GPIOB
#define 	GPIOB_DR        	(*(vuint16_t *) (0x00F1A1)) 	// GPIOB
#define 	GPIOB_DDR       	(*(vuint16_t *) (0x00F1A2)) 	// GPIOB
#define 	GPIOB_PER       	(*(vuint16_t *) (0x00F1A3)) 	// GPIOB
#define 	GPIOB_IENR      	(*(vuint16_t *) (0x00F1A5)) 	// GPIOB
#define 	GPIOB_IPOLR     	(*(vuint16_t *) (0x00F1A6)) 	// GPIOB
#define 	GPIOB_IPR       	(*(vuint16_t *) (0x00F1A7)) 	// GPIOB
#define 	GPIOB_IESR      	(*(vuint16_t *) (0x00F1A8)) 	// GPIOB
#define 	GPIOB_RAWDATA   	(*(vuint16_t *) (0x00F1AA)) 	// GPIOB
#define 	GPIOB_DRIVE     	(*(vuint16_t *) (0x00F1AB)) 	// GPIOB
#define 	GPIOB_IFE       	(*(vuint16_t *) (0x00F1AC)) 	// GPIOB
#define 	GPIOB_SLEW      	(*(vuint16_t *) (0x00F1AD)) 	// GPIOB

///////////////////////////////////////////////////////////////////////////////////
// Define GPIOC Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	GPIOC_PUR       	(*(vuint16_t *) (0x00F1C0)) 	// GPIOC
#define 	GPIOC_DR        	(*(vuint16_t *) (0x00F1C1)) 	// GPIOC
#define 	GPIOC_DDR       	(*(vuint16_t *) (0x00F1C2)) 	// GPIOC
#define 	GPIOC_PER       	(*(vuint16_t *) (0x00F1C3)) 	// GPIOC
#define 	GPIOC_IENR      	(*(vuint16_t *) (0x00F1C5)) 	// GPIOC
#define 	GPIOC_IPOLR     	(*(vuint16_t *) (0x00F1C6)) 	// GPIOC
#define 	GPIOC_IPR       	(*(vuint16_t *) (0x00F1C7)) 	// GPIOC
#define 	GPIOC_IESR      	(*(vuint16_t *) (0x00F1C8)) 	// GPIOC
#define 	GPIOC_RAWDATA   	(*(vuint16_t *) (0x00F1CA)) 	// GPIOC
#define 	GPIOC_DRIVE     	(*(vuint16_t *) (0x00F1CB)) 	// GPIOC
#define 	GPIOC_IFE       	(*(vuint16_t *) (0x00F1CC)) 	// GPIOC
#define 	GPIOC_SLEW      	(*(vuint16_t *) (0x00F1CD)) 	// GPIOC

///////////////////////////////////////////////////////////////////////////////////
// Define GPIOD Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	GPIOD_PUR       	(*(vuint16_t *) (0x00F1E0)) 	// GPIOD
#define 	GPIOD_DR        	(*(vuint16_t *) (0x00F1E1)) 	// GPIOD
#define 	GPIOD_DDR       	(*(vuint16_t *) (0x00F1E2)) 	// GPIOD
#define 	GPIOD_PER       	(*(vuint16_t *) (0x00F1E3)) 	// GPIOD
#define 	GPIOD_IENR      	(*(vuint16_t *) (0x00F1E5)) 	// GPIOD
#define 	GPIOD_IPOLR     	(*(vuint16_t *) (0x00F1E6)) 	// GPIOD
#define 	GPIOD_IPR       	(*(vuint16_t *) (0x00F1E7)) 	// GPIOD
#define 	GPIOD_IESR      	(*(vuint16_t *) (0x00F1E8)) 	// GPIOD
#define 	GPIOD_RAWDATA   	(*(vuint16_t *) (0x00F1EA)) 	// GPIOD
#define 	GPIOD_DRIVE     	(*(vuint16_t *) (0x00F1EB)) 	// GPIOD
#define 	GPIOD_IFE       	(*(vuint16_t *) (0x00F1EC)) 	// GPIOD
#define 	GPIOD_SLEW      	(*(vuint16_t *) (0x00F1ED)) 	// GPIOD

///////////////////////////////////////////////////////////////////////////////////
// Define GPIOE Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	GPIOE_PUR       	(*(vuint16_t *) (0x00F200)) 	// GPIOE
#define 	GPIOE_DR        	(*(vuint16_t *) (0x00F201)) 	// GPIOE
#define 	GPIOE_DDR       	(*(vuint16_t *) (0x00F202)) 	// GPIOE
#define 	GPIOE_PER       	(*(vuint16_t *) (0x00F203)) 	// GPIOE
#define 	GPIOE_IENR      	(*(vuint16_t *) (0x00F205)) 	// GPIOE
#define 	GPIOE_IPOLR     	(*(vuint16_t *) (0x00F206)) 	// GPIOE
#define 	GPIOE_IPR       	(*(vuint16_t *) (0x00F207)) 	// GPIOE
#define 	GPIOE_IESR      	(*(vuint16_t *) (0x00F208)) 	// GPIOE
#define 	GPIOE_RAWDATA   	(*(vuint16_t *) (0x00F20A)) 	// GPIOE
#define 	GPIOE_DRIVE     	(*(vuint16_t *) (0x00F20B)) 	// GPIOE
#define 	GPIOE_IFE       	(*(vuint16_t *) (0x00F20C)) 	// GPIOE
#define 	GPIOE_SLEW      	(*(vuint16_t *) (0x00F20D)) 	// GPIOE

///////////////////////////////////////////////////////////////////////////////////
// Define GPIOF Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	GPIOF_PUR       	(*(vuint16_t *) (0x00F220)) 	// GPIOF
#define 	GPIOF_DR        	(*(vuint16_t *) (0x00F221)) 	// GPIOF
#define 	GPIOF_DDR       	(*(vuint16_t *) (0x00F222)) 	// GPIOF
#define 	GPIOF_PER       	(*(vuint16_t *) (0x00F223)) 	// GPIOF
#define 	GPIOF_IENR      	(*(vuint16_t *) (0x00F225)) 	// GPIOF
#define 	GPIOF_IPOLR     	(*(vuint16_t *) (0x00F226)) 	// GPIOF
#define 	GPIOF_IPR       	(*(vuint16_t *) (0x00F227)) 	// GPIOF
#define 	GPIOF_IESR      	(*(vuint16_t *) (0x00F228)) 	// GPIOF
#define 	GPIOF_RAWDATA   	(*(vuint16_t *) (0x00F22A)) 	// GPIOF
#define 	GPIOF_DRIVE     	(*(vuint16_t *) (0x00F22B)) 	// GPIOF
#define 	GPIOF_IFE       	(*(vuint16_t *) (0x00F22C)) 	// GPIOF
#define 	GPIOF_SLEW      	(*(vuint16_t *) (0x00F22D)) 	// GPIOF

///////////////////////////////////////////////////////////////////////////////////
// Define SIM Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	SIM_CTRL        	(*(vuint16_t *) (0x00F240)) 	// SIM
#define 	SIM_RSTAT       	(*(vuint16_t *) (0x00F241)) 	// SIM
#define 	SIM_MSHID       	(*(vuint16_t *) (0x00F242)) 	// SIM
#define 	SIM_LSHID       	(*(vuint16_t *) (0x00F243)) 	// SIM
#define 	SIM_TEST        	(*(vuint16_t *) (0x00F244)) 	// SIM
#define 	SIM_CLKOUT      	(*(vuint16_t *) (0x00F245)) 	// SIM
#define 	SIM_PCR         	(*(vuint16_t *) (0x00F246)) 	// SIM
#define 	SIM_PCE         	(*(vuint16_t *) (0x00F247)) 	// SIM
#define 	SIM_SDR         	(*(vuint16_t *) (0x00F248)) 	// SIM
#define 	SIM_ISAL        	(*(vuint16_t *) (0x00F249)) 	// SIM
#define 	SIM_PROT        	(*(vuint16_t *) (0x00F24A)) 	// SIM
#define 	SIM_GPSA        	(*(vuint16_t *) (0x00F24B)) 	// SIM
#define 	SIM_GPSB0       	(*(vuint16_t *) (0x00F24C)) 	// SIM
#define 	SIM_GPSB1       	(*(vuint16_t *) (0x00F24D)) 	// SIM
#define 	SIM_GPSC        	(*(vuint16_t *) (0x00F24E)) 	// SIM
#define 	SIM_GPSD        	(*(vuint16_t *) (0x00F24F)) 	// SIM
#define 	SIM_IPS0        	(*(vuint16_t *) (0x00F250)) 	// SIM
#define 	SIM_IPS1        	(*(vuint16_t *) (0x00F251)) 	// SIM

///////////////////////////////////////////////////////////////////////////////////
// Define PMC Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	PMC_SCR         	(*(vuint16_t *) (0x00F260)) 	// PMC
#define 	PMC_CR2         	(*(vuint16_t *) (0x00F261)) 	// PMC
#define 	PMC_TESTSC      	(*(vuint16_t *) (0x00F262)) 	// PMC

///////////////////////////////////////////////////////////////////////////////////
// Define CMP0 Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	CMP0_CR0        	(*(vuint16_t *) (0x00F280)) 	// CMP0
#define 	CMP0_CR1        	(*(vuint16_t *) (0x00F281)) 	// CMP0
#define 	CMP0_FPR        	(*(vuint16_t *) (0x00F282)) 	// CMP0
#define 	CMP0_SCR        	(*(vuint16_t *) (0x00F283)) 	// CMP0

///////////////////////////////////////////////////////////////////////////////////
// Define CMP1 Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	CMP1_CR0        	(*(vuint16_t *) (0x00F2A0)) 	// CMP1
#define 	CMP1_CR1        	(*(vuint16_t *) (0x00F2A1)) 	// CMP1
#define 	CMP1_FPR        	(*(vuint16_t *) (0x00F2A2)) 	// CMP1
#define 	CMP1_SCR        	(*(vuint16_t *) (0x00F2A3)) 	// CMP1

///////////////////////////////////////////////////////////////////////////////////
// Define CMP2 Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	CMP2_CR0        	(*(vuint16_t *) (0x00F2C0)) 	// CMP2
#define 	CMP2_CR1        	(*(vuint16_t *) (0x00F2C1)) 	// CMP2
#define 	CMP2_FPR        	(*(vuint16_t *) (0x00F2C2)) 	// CMP2
#define 	CMP2_SCR        	(*(vuint16_t *) (0x00F2C3)) 	// CMP2

///////////////////////////////////////////////////////////////////////////////////
// Define PIT Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	PIT_CTRL        	(*(vuint16_t *) (0x00F2E0)) 	// PIT
#define 	PIT_MOD         	(*(vuint16_t *) (0x00F2E1)) 	// PIT
#define 	PIT_CNTR        	(*(vuint16_t *) (0x00F2E2)) 	// PIT

///////////////////////////////////////////////////////////////////////////////////
// Define PDB Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	PDB_SCR         	(*(vuint16_t *) (0x00F300)) 	// PDB
#define 	PDB_DELAYA      	(*(vuint16_t *) (0x00F301)) 	// PDB
#define 	PDB_DELAYB      	(*(vuint16_t *) (0x00F302)) 	// PDB
#define 	PDB_MOD         	(*(vuint16_t *) (0x00F303)) 	// PDB
#define 	PDB_COUNT       	(*(vuint16_t *) (0x00F304)) 	// PDB

///////////////////////////////////////////////////////////////////////////////////
// Define RTC Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	RTC_SC          	(*(vuint16_t *) (0x00F320)) 	// RTC
#define 	RTC_CNT         	(*(vuint16_t *) (0x00F321)) 	// RTC
#define 	RTC_MOD         	(*(vuint16_t *) (0x00F322)) 	// RTC

///////////////////////////////////////////////////////////////////////////////////
// Define HFM Registers
///////////////////////////////////////////////////////////////////////////////////
#define 	FM_CLKDIV       	(*(vuint16_t *) (0x00F400)) 	// HFM
#define 	FM_CNFG         	(*(vuint16_t *) (0x00F401)) 	// HFM
#define 	FM_TEST         	(*(vuint16_t *) (0x00F402)) 	// HFM
#define 	FM_SECHI        	(*(vuint16_t *) (0x00F403)) 	// HFM
#define 	FM_SECLO        	(*(vuint16_t *) (0x00F404)) 	// HFM
#define 	FM_MONITOR      	(*(vuint16_t *) (0x00F405)) 	// HFM
#define 	FM_PROT         	(*(vuint16_t *) (0x00F410)) 	// HFM
#define 	FM_TSTAT        	(*(vuint16_t *) (0x00F412)) 	// HFM
#define 	FM_USTAT        	(*(vuint16_t *) (0x00F413)) 	// HFM
#define 	FM_CMD          	(*(vuint16_t *) (0x00F414)) 	// HFM
#define 	FM_CONTROL      	(*(vuint16_t *) (0x00F415)) 	// HFM
#define 	FM_ADDR         	(*(vuint16_t *) (0x00F416)) 	// HFM
#define 	FM_DATA         	(*(vuint16_t *) (0x00F418)) 	// HFM
#define 	FM_OPT0         	(*(vuint16_t *) (0x00F41A)) 	// HFM
#define 	FM_OPT1         	(*(vuint16_t *) (0x00F41B)) 	// HFM
#define 	FM_MEM_SEL      	(*(vuint16_t *) (0x00F41C)) 	// HFM
#define 	FM_TSTSIG       	(*(vuint16_t *) (0x00F41D)) 	// HFM

///////////////////////////////////////////////////////////////////////////////////
// Generic Bit Definitions Used Elsewhere in this File
#ifndef __CPU_H
#define		BIT0	0x0001
#define		BIT1	0x0002
#define		BIT2	0x0004
#define		BIT3	0x0008
#define		BIT4	0x0010
#define		BIT5	0x0020
#define		BIT6	0x0040
#define		BIT7	0x0080
#define		BIT8	0x0100
#define		BIT9	0x0200
#define		BIT10	0x0400
#define		BIT11	0x0800
#define		BIT12	0x1000
#define		BIT13	0x2000
#define		BIT14	0x4000
#define		BIT15	0x8000
#endif __CPU_H
///////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////
// TMR0 Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// TMR0_COMP1 Bit-Fields:
#define TMR0_COMP1_COMPARISON_1        	0xFFFF

// TMR0_COMP2 Bit-Fields:
#define TMR0_COMP2_COMPARISON_2        	0xFFFF

// TMR0_CAPT Bit-Fields:
#define TMR0_CAPT_CAPTURE              	0xFFFF

// TMR0_LOAD Bit-Fields:
#define TMR0_LOAD_LOAD                 	0xFFFF

// TMR0_HOLD Bit-Fields:
#define TMR0_HOLD_HOLD                 	0xFFFF

// TMR0_CNTR Bit-Fields:
#define TMR0_CNTR_COUNTER              	0xFFFF

// TMR0_CTRL Bit-Fields:
#define TMR0_CTRL_CM                   	(BIT15+BIT14+BIT13)
#define TMR0_CTRL_CM_2                 	BIT15
#define TMR0_CTRL_CM_1                 	BIT14
#define TMR0_CTRL_CM_0                 	BIT13
#define TMR0_CTRL_PCS                  	(BIT12+BIT11+BIT10+BIT9)
#define TMR0_CTRL_PCS_3                	BIT12
#define TMR0_CTRL_PCS_2                	BIT11
#define TMR0_CTRL_PCS_1                	BIT10
#define TMR0_CTRL_PCS_0                	BIT9
#define TMR0_CTRL_SCS                  	(BIT8+BIT7)
#define TMR0_CTRL_SCS_1                	BIT8
#define TMR0_CTRL_SCS_0                	BIT7
#define TMR0_CTRL_ONCE                 	BIT6
#define TMR0_CTRL_LENGTH               	BIT5
#define TMR0_CTRL_DIR                  	BIT4
#define TMR0_CTRL_Co_INIT              	BIT3
#define TMR0_CTRL_OM                   	(BIT2+BIT1+BIT0)
#define TMR0_CTRL_OM_2                 	BIT2
#define TMR0_CTRL_OM_1                 	BIT1
#define TMR0_CTRL_OM_0                 	BIT0

// TMR0_SCTRL Bit-Fields:
#define TMR0_SCTRL_TCF                 	BIT15
#define TMR0_SCTRL_TCFIE               	BIT14
#define TMR0_SCTRL_TOF                 	BIT13
#define TMR0_SCTRL_TOFIE               	BIT12
#define TMR0_SCTRL_IEF                 	BIT11
#define TMR0_SCTRL_IEFIE               	BIT10
#define TMR0_SCTRL_IPS                 	BIT9
#define TMR0_SCTRL_INPUT               	BIT8
#define TMR0_SCTRL_CAPTURE_MODE        	(BIT7+BIT6)
#define TMR0_SCTRL_CAPTURE_MODE_1      	BIT7
#define TMR0_SCTRL_CAPTURE_MODE_0      	BIT6
#define TMR0_SCTRL_MSTR                	BIT5
#define TMR0_SCTRL_EEOF                	BIT4
#define TMR0_SCTRL_VAL                 	BIT3
#define TMR0_SCTRL_FORCE               	BIT2
#define TMR0_SCTRL_OPS                 	BIT1
#define TMR0_SCTRL_OEN                 	BIT0

// TMR0_CMPLD1 Bit-Fields:
#define TMR0_CMPLD1_COMPARATOR_LOAD_1  	0xFFFF

// TMR0_CMPLD2 Bit-Fields:
#define TMR0_CMPLD2_COMPARATOR_LOAD_2  	0xFFFF

// TMR0_CSCTRL Bit-Fields:
#define TMR0_CSCTRL_DBG_EN             	(BIT15+BIT14)
#define TMR0_CSCTRL_DBG_EN_1           	BIT15
#define TMR0_CSCTRL_DBG_EN_0           	BIT14
#define TMR0_CSCTRL_TCF2EN             	BIT7
#define TMR0_CSCTRL_TCF1EN             	BIT6
#define TMR0_CSCTRL_TCF2               	BIT5
#define TMR0_CSCTRL_TCF1               	BIT4
#define TMR0_CSCTRL_CL2                	(BIT3+BIT2)
#define TMR0_CSCTRL_CL2_1              	BIT3
#define TMR0_CSCTRL_CL2_0              	BIT2
#define TMR0_CSCTRL_CL1                	(BIT1+BIT0)
#define TMR0_CSCTRL_CL1_1              	BIT1
#define TMR0_CSCTRL_CL1_0              	BIT0

// TMR0_FILT Bit-Fields:
#define TMR0_FILT_FILT_CNT             	(BIT10+BIT9+BIT8)
#define TMR0_FILT_FILT_CNT_2           	BIT10
#define TMR0_FILT_FILT_CNT_1           	BIT9
#define TMR0_FILT_FILT_CNT_0           	BIT8
#define TMR0_FILT_FILT_PER             	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define TMR0_FILT_FILT_PER_7           	BIT7
#define TMR0_FILT_FILT_PER_6           	BIT6
#define TMR0_FILT_FILT_PER_5           	BIT5
#define TMR0_FILT_FILT_PER_4           	BIT4
#define TMR0_FILT_FILT_PER_3           	BIT3
#define TMR0_FILT_FILT_PER_2           	BIT2
#define TMR0_FILT_FILT_PER_1           	BIT1
#define TMR0_FILT_FILT_PER_0           	BIT0

// TMR_ENBL Bit-Fields:
#define TMR_ENBL_ENBL                  	(BIT1+BIT0)
#define TMR_ENBL_ENBL_1                	BIT1
#define TMR_ENBL_ENBL_0                	BIT0

///////////////////////////////////////////////////////////////////////////////////
// TMR1 Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// TMR1_COMP1 Bit-Fields:
#define TMR1_COMP1_COMPARISON_1        	0xFFFF

// TMR1_COMP2 Bit-Fields:
#define TMR1_COMP2_COMPARISON_2        	0xFFFF

// TMR1_CAPT Bit-Fields:
#define TMR1_CAPT_CAPTURE              	0xFFFF

// TMR1_LOAD Bit-Fields:
#define TMR1_LOAD_LOAD                 	0xFFFF

// TMR1_HOLD Bit-Fields:
#define TMR1_HOLD_HOLD                 	0xFFFF

// TMR1_CNTR Bit-Fields:
#define TMR1_CNTR_COUNTER              	0xFFFF

// TMR1_CTRL Bit-Fields:
#define TMR1_CTRL_CM                   	(BIT15+BIT14+BIT13)
#define TMR1_CTRL_CM_2                 	BIT15
#define TMR1_CTRL_CM_1                 	BIT14
#define TMR1_CTRL_CM_0                 	BIT13
#define TMR1_CTRL_PCS                  	(BIT12+BIT11+BIT10+BIT9)
#define TMR1_CTRL_PCS_3                	BIT12
#define TMR1_CTRL_PCS_2                	BIT11
#define TMR1_CTRL_PCS_1                	BIT10
#define TMR1_CTRL_PCS_0                	BIT9
#define TMR1_CTRL_SCS                  	(BIT8+BIT7)
#define TMR1_CTRL_SCS_1                	BIT8
#define TMR1_CTRL_SCS_0                	BIT7
#define TMR1_CTRL_ONCE                 	BIT6
#define TMR1_CTRL_LENGTH               	BIT5
#define TMR1_CTRL_DIR                  	BIT4
#define TMR1_CTRL_Co_INIT              	BIT3
#define TMR1_CTRL_OM                   	(BIT2+BIT1+BIT0)
#define TMR1_CTRL_OM_2                 	BIT2
#define TMR1_CTRL_OM_1                 	BIT1
#define TMR1_CTRL_OM_0                 	BIT0

// TMR1_SCTRL Bit-Fields:
#define TMR1_SCTRL_TCF                 	BIT15
#define TMR1_SCTRL_TCFIE               	BIT14
#define TMR1_SCTRL_TOF                 	BIT13
#define TMR1_SCTRL_TOFIE               	BIT12
#define TMR1_SCTRL_IEF                 	BIT11
#define TMR1_SCTRL_IEFIE               	BIT10
#define TMR1_SCTRL_IPS                 	BIT9
#define TMR1_SCTRL_INPUT               	BIT8
#define TMR1_SCTRL_CAPTURE_MODE        	(BIT7+BIT6)
#define TMR1_SCTRL_CAPTURE_MODE_1      	BIT7
#define TMR1_SCTRL_CAPTURE_MODE_0      	BIT6
#define TMR1_SCTRL_MSTR                	BIT5
#define TMR1_SCTRL_EEOF                	BIT4
#define TMR1_SCTRL_VAL                 	BIT3
#define TMR1_SCTRL_FORCE               	BIT2
#define TMR1_SCTRL_OPS                 	BIT1
#define TMR1_SCTRL_OEN                 	BIT0

// TMR1_CMPLD1 Bit-Fields:
#define TMR1_CMPLD1_COMPARATOR_LOAD_1  	0xFFFF

// TMR1_CMPLD2 Bit-Fields:
#define TMR1_CMPLD2_COMPARATOR_LOAD_2  	0xFFFF

// TMR1_CSCTRL Bit-Fields:
#define TMR1_CSCTRL_DBG_EN             	(BIT15+BIT14)
#define TMR1_CSCTRL_DBG_EN_1           	BIT15
#define TMR1_CSCTRL_DBG_EN_0           	BIT14
#define TMR1_CSCTRL_TCF2EN             	BIT7
#define TMR1_CSCTRL_TCF1EN             	BIT6
#define TMR1_CSCTRL_TCF2               	BIT5
#define TMR1_CSCTRL_TCF1               	BIT4
#define TMR1_CSCTRL_CL2                	(BIT3+BIT2)
#define TMR1_CSCTRL_CL2_1              	BIT3
#define TMR1_CSCTRL_CL2_0              	BIT2
#define TMR1_CSCTRL_CL1                	(BIT1+BIT0)
#define TMR1_CSCTRL_CL1_1              	BIT1
#define TMR1_CSCTRL_CL1_0              	BIT0

// TMR1_FILT Bit-Fields:
#define TMR1_FILT_FILT_CNT             	(BIT10+BIT9+BIT8)
#define TMR1_FILT_FILT_CNT_2           	BIT10
#define TMR1_FILT_FILT_CNT_1           	BIT9
#define TMR1_FILT_FILT_CNT_0           	BIT8
#define TMR1_FILT_FILT_PER             	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define TMR1_FILT_FILT_PER_7           	BIT7
#define TMR1_FILT_FILT_PER_6           	BIT6
#define TMR1_FILT_FILT_PER_5           	BIT5
#define TMR1_FILT_FILT_PER_4           	BIT4
#define TMR1_FILT_FILT_PER_3           	BIT3
#define TMR1_FILT_FILT_PER_2           	BIT2
#define TMR1_FILT_FILT_PER_1           	BIT1
#define TMR1_FILT_FILT_PER_0           	BIT0

///////////////////////////////////////////////////////////////////////////////////
// PWM Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// PWM_CTRL Bit-Fields:
#define PWM_CTRL_LDFQ                  	(BIT15+BIT14+BIT13+BIT12)
#define PWM_CTRL_LDFQ_3                	BIT15
#define PWM_CTRL_LDFQ_2                	BIT14
#define PWM_CTRL_LDFQ_1                	BIT13
#define PWM_CTRL_LDFQ_0                	BIT12
#define PWM_CTRL_HALF                  	BIT11
#define PWM_CTRL_IPOL2                 	BIT10
#define PWM_CTRL_IPOL1                 	BIT9
#define PWM_CTRL_IPOL0                 	BIT8
#define PWM_CTRL_PRSC                  	(BIT7+BIT6)
#define PWM_CTRL_PRSC_1                	BIT7
#define PWM_CTRL_PRSC_0                	BIT6
#define PWM_CTRL_PWMRIE                	BIT5
#define PWM_CTRL_PWMF                  	BIT4
#define PWM_CTRL_ISENS                 	(BIT3+BIT2)
#define PWM_CTRL_ISENS_1               	BIT3
#define PWM_CTRL_ISENS_0               	BIT2
#define PWM_CTRL_LDOK                  	BIT1
#define PWM_CTRL_PWMEN                 	BIT0

// PWM_FCTRL Bit-Fields:
#define PWM_FCTRL_FPOL3                	BIT11
#define PWM_FCTRL_FPOL2                	BIT10
#define PWM_FCTRL_FPOL1                	BIT9
#define PWM_FCTRL_FPOL0                	BIT8
#define PWM_FCTRL_FIE3                 	BIT7
#define PWM_FCTRL_FMODE3               	BIT6
#define PWM_FCTRL_FIE2                 	BIT5
#define PWM_FCTRL_FMODE2               	BIT4
#define PWM_FCTRL_FIE1                 	BIT3
#define PWM_FCTRL_FMODE1               	BIT2
#define PWM_FCTRL_FIE0                 	BIT1
#define PWM_FCTRL_FMODE0               	BIT0

// PWM_FLTACK Bit-Fields:
#define PWM_FLTACK_FPIN3               	BIT15
#define PWM_FLTACK_FFLAG3              	BIT14
#define PWM_FLTACK_FPIN2               	BIT13
#define PWM_FLTACK_FFLAG2              	BIT12
#define PWM_FLTACK_FPIN1               	BIT11
#define PWM_FLTACK_FFLAG1              	BIT10
#define PWM_FLTACK_FPIN0               	BIT9
#define PWM_FLTACK_FFLAG0              	BIT8
#define PWM_FLTACK_FTACL3              	BIT6
#define PWM_FLTACK_DT5                 	BIT5
#define PWM_FLTACK_DT4_FTACK2          	BIT4
#define PWM_FLTACK_Dt3                 	BIT3
#define PWM_FLTACK_DT2_FTACK1          	BIT2
#define PWM_FLTACK_DT1                 	BIT1
#define PWM_FLTACK_DT0_FTACK0          	BIT0

// PWM_OUT Bit-Fields:
#define PWM_OUT_PAD_EN                 	BIT15
#define PWM_OUT_OUTCTL5                	BIT13
#define PWM_OUT_OUTCTL4                	BIT12
#define PWM_OUT_OUTCTL3                	BIT11
#define PWM_OUT_OUTCTL2                	BIT10
#define PWM_OUT_OUTCTL1                	BIT9
#define PWM_OUT_OUTCTL0                	BIT8
#define PWM_OUT_OUt5                   	BIT5
#define PWM_OUT_OUT4                   	BIT4
#define PWM_OUT_OUT3                   	BIT3
#define PWM_OUT_OUT2                   	BIT2
#define PWM_OUT_OUT1                   	BIT1
#define PWM_OUT_OUT0                   	BIT0

// PWM_CNTR Bit-Fields:
#define PWM_CNTR_CR                    	(BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_CNTR_CR_14                 	BIT14
#define PWM_CNTR_CR_13                 	BIT13
#define PWM_CNTR_CR_12                 	BIT12
#define PWM_CNTR_CR_11                 	BIT11
#define PWM_CNTR_CR_10                 	BIT10
#define PWM_CNTR_CR_9                  	BIT9
#define PWM_CNTR_CR_8                  	BIT8
#define PWM_CNTR_CR_7                  	BIT7
#define PWM_CNTR_CR_6                  	BIT6
#define PWM_CNTR_CR_5                  	BIT5
#define PWM_CNTR_CR_4                  	BIT4
#define PWM_CNTR_CR_3                  	BIT3
#define PWM_CNTR_CR_2                  	BIT2
#define PWM_CNTR_CR_1                  	BIT1
#define PWM_CNTR_CR_0                  	BIT0

// PWM_CMOD Bit-Fields:
#define PWM_CMOD_PWMCM                 	(BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_CMOD_PWMCM_14              	BIT14
#define PWM_CMOD_PWMCM_13              	BIT13
#define PWM_CMOD_PWMCM_12              	BIT12
#define PWM_CMOD_PWMCM_11              	BIT11
#define PWM_CMOD_PWMCM_10              	BIT10
#define PWM_CMOD_PWMCM_9               	BIT9
#define PWM_CMOD_PWMCM_8               	BIT8
#define PWM_CMOD_PWMCM_7               	BIT7
#define PWM_CMOD_PWMCM_6               	BIT6
#define PWM_CMOD_PWMCM_5               	BIT5
#define PWM_CMOD_PWMCM_4               	BIT4
#define PWM_CMOD_PWMCM_3               	BIT3
#define PWM_CMOD_PWMCM_2               	BIT2
#define PWM_CMOD_PWMCM_1               	BIT1
#define PWM_CMOD_PWMCM_0               	BIT0

// PWM_VAL0 Bit-Fields:
#define PWM_VAL0_PMVAL                 	0xFFFF

// PWM_VAL1 Bit-Fields:
#define PWM_VAL1_PMVAL                 	0xFFFF

// PWM_VAL2 Bit-Fields:
#define PWM_VAL2_PMVAL                 	0xFFFF

// PWM_VAL3 Bit-Fields:
#define PWM_VAL3_PMVAL                 	0xFFFF

// PWM_VAL4 Bit-Fields:
#define PWM_VAL4_PMVAL                 	0xFFFF

// PWM_VAL5 Bit-Fields:
#define PWM_VAL5_PMVAL                 	0xFFFF

// PWM_DTIM0 Bit-Fields:
#define PWM_DTIM0_PWMDT0               	(BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_DTIM0_PWMDT0_11            	BIT11
#define PWM_DTIM0_PWMDT0_10            	BIT10
#define PWM_DTIM0_PWMDT0_9             	BIT9
#define PWM_DTIM0_PWMDT0_8             	BIT8
#define PWM_DTIM0_PWMDT0_7             	BIT7
#define PWM_DTIM0_PWMDT0_6             	BIT6
#define PWM_DTIM0_PWMDT0_5             	BIT5
#define PWM_DTIM0_PWMDT0_4             	BIT4
#define PWM_DTIM0_PWMDT0_3             	BIT3
#define PWM_DTIM0_PWMDT0_2             	BIT2
#define PWM_DTIM0_PWMDT0_1             	BIT1
#define PWM_DTIM0_PWMDT0_0             	BIT0

// PWM_DTIM1 Bit-Fields:
#define PWM_DTIM1_PWMDT1               	(BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_DTIM1_PWMDT1_11            	BIT11
#define PWM_DTIM1_PWMDT1_10            	BIT10
#define PWM_DTIM1_PWMDT1_9             	BIT9
#define PWM_DTIM1_PWMDT1_8             	BIT8
#define PWM_DTIM1_PWMDT1_7             	BIT7
#define PWM_DTIM1_PWMDT1_6             	BIT6
#define PWM_DTIM1_PWMDT1_5             	BIT5
#define PWM_DTIM1_PWMDT1_4             	BIT4
#define PWM_DTIM1_PWMDT1_3             	BIT3
#define PWM_DTIM1_PWMDT1_2             	BIT2
#define PWM_DTIM1_PWMDT1_1             	BIT1
#define PWM_DTIM1_PWMDT1_0             	BIT0

// PWM_DMAP1 Bit-Fields:
#define PWM_DMAP1_DISMAP_15_0          	0xFFFF

// PWM_DMAP2 Bit-Fields:
#define PWM_DMAP2_DISMAP_23_16         	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_DMAP2_DISMAP_23_16_7       	BIT7
#define PWM_DMAP2_DISMAP_23_16_6       	BIT6
#define PWM_DMAP2_DISMAP_23_16_5       	BIT5
#define PWM_DMAP2_DISMAP_23_16_4       	BIT4
#define PWM_DMAP2_DISMAP_23_16_3       	BIT3
#define PWM_DMAP2_DISMAP_23_16_2       	BIT2
#define PWM_DMAP2_DISMAP_23_16_1       	BIT1
#define PWM_DMAP2_DISMAP_23_16_0       	BIT0

// PWM_CNFG Bit-Fields:
#define PWM_CNFG_DBG_EN                	BIT14
#define PWM_CNFG_WAIT_EN               	BIT13
#define PWM_CNFG_EDG                   	BIT12
#define PWM_CNFG_TOPNEG45              	BIT10
#define PWM_CNFG_TOPNEG23              	BIT9
#define PWM_CNFG_TOPNEG01              	BIT8
#define PWM_CNFG_BOTNEG45              	BIT6
#define PWM_CNFG_BOTNEG23              	BIT5
#define PWM_CNFG_BOTNEG01              	BIT4
#define PWM_CNFG_INDEP45               	BIT3
#define PWM_CNFG_INDEP23               	BIT2
#define PWM_CNFG_INDEP01               	BIT1
#define PWM_CNFG_WP                    	BIT0

// PWM_CCTRL Bit-Fields:
#define PWM_CCTRL_ENHA                 	BIT15
#define PWM_CCTRL_nBX                  	BIT14
#define PWM_CCTRL_MSK5                 	BIT13
#define PWM_CCTRL_MSK4                 	BIT12
#define PWM_CCTRL_MSK3                 	BIT11
#define PWM_CCTRL_MSK2                 	BIT10
#define PWM_CCTRL_MSK1                 	BIT9
#define PWM_CCTRL_MSK0                 	BIT8
#define PWM_CCTRL_VLMODE               	(BIT5+BIT4)
#define PWM_CCTRL_VLMODE_1             	BIT5
#define PWM_CCTRL_VLMODE_0             	BIT4
#define PWM_CCTRL_SWP45                	BIT2
#define PWM_CCTRL_SWP23                	BIT1
#define PWM_CCTRL_SWP01                	BIT0

// PWM_PORT Bit-Fields:
#define PWM_PORT_PORT                  	(BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_PORT_PORT_6                	BIT6
#define PWM_PORT_PORT_5                	BIT5
#define PWM_PORT_PORT_4                	BIT4
#define PWM_PORT_PORT_3                	BIT3
#define PWM_PORT_PORT_2                	BIT2
#define PWM_PORT_PORT_1                	BIT1
#define PWM_PORT_PORT_0                	BIT0

// PWM_ICCTRL Bit-Fields:
#define PWM_ICCTRL_PEC2                	BIT5
#define PWM_ICCTRL_PEC1                	BIT4
#define PWM_ICCTRL_PEC0                	BIT3
#define PWM_ICCTRL_ICC2                	BIT2
#define PWM_ICCTRL_ICC1                	BIT1
#define PWM_ICCTRL_ICC0                	BIT0

// PWM_SCTRL Bit-Fields:
#define PWM_SCTRL_CINV5                	BIT13
#define PWM_SCTRL_CINV4                	BIT12
#define PWM_SCTRL_CINV3                	BIT11
#define PWM_SCTRL_CINV2                	BIT10
#define PWM_SCTRL_CINV1                	BIT9
#define PWM_SCTRL_CINV0                	BIT8
#define PWM_SCTRL_SRC2                 	(BIT6+BIT5)
#define PWM_SCTRL_SRC2_1               	BIT6
#define PWM_SCTRL_SRC2_0               	BIT5
#define PWM_SCTRL_SRC1                 	(BIT3+BIT2)
#define PWM_SCTRL_SRC1_1               	BIT3
#define PWM_SCTRL_SRC1_0               	BIT2
#define PWM_SCTRL_SRC0                 	BIT0

// PWM_SYNC Bit-Fields:
#define PWM_SYNC_SYNC_OUT_EN           	BIT15
#define PWM_SYNC_SYNC_WINDOW           	(BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_SYNC_SYNC_WINDOW_14        	BIT14
#define PWM_SYNC_SYNC_WINDOW_13        	BIT13
#define PWM_SYNC_SYNC_WINDOW_12        	BIT12
#define PWM_SYNC_SYNC_WINDOW_11        	BIT11
#define PWM_SYNC_SYNC_WINDOW_10        	BIT10
#define PWM_SYNC_SYNC_WINDOW_9         	BIT9
#define PWM_SYNC_SYNC_WINDOW_8         	BIT8
#define PWM_SYNC_SYNC_WINDOW_7         	BIT7
#define PWM_SYNC_SYNC_WINDOW_6         	BIT6
#define PWM_SYNC_SYNC_WINDOW_5         	BIT5
#define PWM_SYNC_SYNC_WINDOW_4         	BIT4
#define PWM_SYNC_SYNC_WINDOW_3         	BIT3
#define PWM_SYNC_SYNC_WINDOW_2         	BIT2
#define PWM_SYNC_SYNC_WINDOW_1         	BIT1
#define PWM_SYNC_SYNC_WINDOW_0         	BIT0

// PWM_FFILT0 Bit-Fields:
#define PWM_FFILT0_FILT0_CNT           	(BIT10+BIT9+BIT8)
#define PWM_FFILT0_FILT0_CNT_2         	BIT10
#define PWM_FFILT0_FILT0_CNT_1         	BIT9
#define PWM_FFILT0_FILT0_CNT_0         	BIT8
#define PWM_FFILT0_FILT0_PER           	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_FFILT0_FILT0_PER_7         	BIT7
#define PWM_FFILT0_FILT0_PER_6         	BIT6
#define PWM_FFILT0_FILT0_PER_5         	BIT5
#define PWM_FFILT0_FILT0_PER_4         	BIT4
#define PWM_FFILT0_FILT0_PER_3         	BIT3
#define PWM_FFILT0_FILT0_PER_2         	BIT2
#define PWM_FFILT0_FILT0_PER_1         	BIT1
#define PWM_FFILT0_FILT0_PER_0         	BIT0

// PWM_FFILT1 Bit-Fields:
#define PWM_FFILT1_FILT1_CNT           	(BIT10+BIT9+BIT8)
#define PWM_FFILT1_FILT1_CNT_2         	BIT10
#define PWM_FFILT1_FILT1_CNT_1         	BIT9
#define PWM_FFILT1_FILT1_CNT_0         	BIT8
#define PWM_FFILT1_FILT1_PER           	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_FFILT1_FILT1_PER_7         	BIT7
#define PWM_FFILT1_FILT1_PER_6         	BIT6
#define PWM_FFILT1_FILT1_PER_5         	BIT5
#define PWM_FFILT1_FILT1_PER_4         	BIT4
#define PWM_FFILT1_FILT1_PER_3         	BIT3
#define PWM_FFILT1_FILT1_PER_2         	BIT2
#define PWM_FFILT1_FILT1_PER_1         	BIT1
#define PWM_FFILT1_FILT1_PER_0         	BIT0

// PWM_FFILT2 Bit-Fields:
#define PWM_FFILT2_FILT2_CNT           	(BIT10+BIT9+BIT8)
#define PWM_FFILT2_FILT2_CNT_2         	BIT10
#define PWM_FFILT2_FILT2_CNT_1         	BIT9
#define PWM_FFILT2_FILT2_CNT_0         	BIT8
#define PWM_FFILT2_FILT2_PER           	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_FFILT2_FILT2_PER_7         	BIT7
#define PWM_FFILT2_FILT2_PER_6         	BIT6
#define PWM_FFILT2_FILT2_PER_5         	BIT5
#define PWM_FFILT2_FILT2_PER_4         	BIT4
#define PWM_FFILT2_FILT2_PER_3         	BIT3
#define PWM_FFILT2_FILT2_PER_2         	BIT2
#define PWM_FFILT2_FILT2_PER_1         	BIT1
#define PWM_FFILT2_FILT2_PER_0         	BIT0

// PWM_FFILT3 Bit-Fields:
#define PWM_FFILT3_FILT3_CNT           	(BIT10+BIT9+BIT8)
#define PWM_FFILT3_FILT3_CNT_2         	BIT10
#define PWM_FFILT3_FILT3_CNT_1         	BIT9
#define PWM_FFILT3_FILT3_CNT_0         	BIT8
#define PWM_FFILT3_FILT3_PER           	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define PWM_FFILT3_FILT3_PER_7         	BIT7
#define PWM_FFILT3_FILT3_PER_6         	BIT6
#define PWM_FFILT3_FILT3_PER_5         	BIT5
#define PWM_FFILT3_FILT3_PER_4         	BIT4
#define PWM_FFILT3_FILT3_PER_3         	BIT3
#define PWM_FFILT3_FILT3_PER_2         	BIT2
#define PWM_FFILT3_FILT3_PER_1         	BIT1
#define PWM_FFILT3_FILT3_PER_0         	BIT0

///////////////////////////////////////////////////////////////////////////////////
// INTC Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// INTC_ICSR Bit-Fields:
#define INTC_ICSR_INT                  	BIT15
#define INTC_ICSR_IPIC                 	(BIT14+BIT13)
#define INTC_ICSR_IPIC_1               	BIT14
#define INTC_ICSR_IPIC_0               	BIT13
#define INTC_ICSR_VAB                  	(BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6)
#define INTC_ICSR_VAB_6                	BIT12
#define INTC_ICSR_VAB_5                	BIT11
#define INTC_ICSR_VAB_4                	BIT10
#define INTC_ICSR_VAB_3                	BIT9
#define INTC_ICSR_VAB_2                	BIT8
#define INTC_ICSR_VAB_1                	BIT7
#define INTC_ICSR_VAB_0                	BIT6
#define INTC_ICSR_INT_DIS              	BIT5
#define INTC_ICSR_ERRF                 	BIT4
#define INTC_ICSR_ETRE                 	BIT3
#define INTC_ICSR_TRBUF                	BIT2
#define INTC_ICSR_BKPT                 	BIT1
#define INTC_ICSR_STPCNT               	BIT0

// INTC_VBA Bit-Fields:
#define INTC_VBA_VECTOR_BASE_ADDRESS   	(BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define INTC_VBA_VECTOR_BASE_ADDRESS_13 	BIT13
#define INTC_VBA_VECTOR_BASE_ADDRESS_12 	BIT12
#define INTC_VBA_VECTOR_BASE_ADDRESS_11 	BIT11
#define INTC_VBA_VECTOR_BASE_ADDRESS_10 	BIT10
#define INTC_VBA_VECTOR_BASE_ADDRESS_9 	BIT9
#define INTC_VBA_VECTOR_BASE_ADDRESS_8 	BIT8
#define INTC_VBA_VECTOR_BASE_ADDRESS_7 	BIT7
#define INTC_VBA_VECTOR_BASE_ADDRESS_6 	BIT6
#define INTC_VBA_VECTOR_BASE_ADDRESS_5 	BIT5
#define INTC_VBA_VECTOR_BASE_ADDRESS_4 	BIT4
#define INTC_VBA_VECTOR_BASE_ADDRESS_3 	BIT3
#define INTC_VBA_VECTOR_BASE_ADDRESS_2 	BIT2
#define INTC_VBA_VECTOR_BASE_ADDRESS_1 	BIT1
#define INTC_VBA_VECTOR_BASE_ADDRESS_0 	BIT0

// INTC_IAR0 Bit-Fields:
#define INTC_IAR0_USER2                	(BIT13+BIT12+BIT11+BIT10+BIT9+BIT8)
#define INTC_IAR0_USER2_5              	BIT13
#define INTC_IAR0_USER2_4              	BIT12
#define INTC_IAR0_USER2_3              	BIT11
#define INTC_IAR0_USER2_2              	BIT10
#define INTC_IAR0_USER2_1              	BIT9
#define INTC_IAR0_USER2_0              	BIT8
#define INTC_IAR0_USER1                	(BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define INTC_IAR0_USER1_5              	BIT5
#define INTC_IAR0_USER1_4              	BIT4
#define INTC_IAR0_USER1_3              	BIT3
#define INTC_IAR0_USER1_2              	BIT2
#define INTC_IAR0_USER1_1              	BIT1
#define INTC_IAR0_USER1_0              	BIT0

// INTC_IAR1 Bit-Fields:
#define INTC_IAR1_USER4                	(BIT13+BIT12+BIT11+BIT10+BIT9+BIT8)
#define INTC_IAR1_USER4_5              	BIT13
#define INTC_IAR1_USER4_4              	BIT12
#define INTC_IAR1_USER4_3              	BIT11
#define INTC_IAR1_USER4_2              	BIT10
#define INTC_IAR1_USER4_1              	BIT9
#define INTC_IAR1_USER4_0              	BIT8
#define INTC_IAR1_USER3                	(BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define INTC_IAR1_USER3_5              	BIT5
#define INTC_IAR1_USER3_4              	BIT4
#define INTC_IAR1_USER3_3              	BIT3
#define INTC_IAR1_USER3_2              	BIT2
#define INTC_IAR1_USER3_1              	BIT1
#define INTC_IAR1_USER3_0              	BIT0

// INTC_IAR2 Bit-Fields:
#define INTC_IAR2_USER6                	(BIT13+BIT12+BIT11+BIT10+BIT9+BIT8)
#define INTC_IAR2_USER6_5              	BIT13
#define INTC_IAR2_USER6_4              	BIT12
#define INTC_IAR2_USER6_3              	BIT11
#define INTC_IAR2_USER6_2              	BIT10
#define INTC_IAR2_USER6_1              	BIT9
#define INTC_IAR2_USER6_0              	BIT8
#define INTC_IAR2_USER5                	(BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define INTC_IAR2_USER5_5              	BIT5
#define INTC_IAR2_USER5_4              	BIT4
#define INTC_IAR2_USER5_3              	BIT3
#define INTC_IAR2_USER5_2              	BIT2
#define INTC_IAR2_USER5_1              	BIT1
#define INTC_IAR2_USER5_0              	BIT0

///////////////////////////////////////////////////////////////////////////////////
// ADC0 Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// ADC0_ADCSC1A Bit-Fields:
#define ADC0_ADCSC1A_COCO              	BIT7
#define ADC0_ADCSC1A_AIEN              	BIT6
#define ADC0_ADCSC1A_ADCO              	BIT5
#define ADC0_ADCSC1A_ADCH              	(BIT4+BIT3+BIT2+BIT1+BIT0)
#define ADC0_ADCSC1A_ADCH_4            	BIT4
#define ADC0_ADCSC1A_ADCH_3            	BIT3
#define ADC0_ADCSC1A_ADCH_2            	BIT2
#define ADC0_ADCSC1A_ADCH_1            	BIT1
#define ADC0_ADCSC1A_ADCH_0            	BIT0

// ADC0_ADCSC2 Bit-Fields:
#define ADC0_ADCSC2_ADACT              	BIT7
#define ADC0_ADCSC2_ADTRG              	BIT6
#define ADC0_ADCSC2_ECC                	BIT2
#define ADC0_ADCSC2_REFSEL             	(BIT1+BIT0)
#define ADC0_ADCSC2_REFSEL_1           	BIT1
#define ADC0_ADCSC2_REFSEL_0           	BIT0

// ADC0_ADCCFG Bit-Fields:
#define ADC0_ADCCFG_ADLPC              	BIT7
#define ADC0_ADCCFG_ADIV               	(BIT6+BIT5)
#define ADC0_ADCCFG_ADIV_1             	BIT6
#define ADC0_ADCCFG_ADIV_0             	BIT5
#define ADC0_ADCCFG_ADLSMP             	BIT4
#define ADC0_ADCCFG_MODE               	(BIT3+BIT2)
#define ADC0_ADCCFG_MODE_1             	BIT3
#define ADC0_ADCCFG_MODE_0             	BIT2
#define ADC0_ADCCFG_ADICLK             	(BIT1+BIT0)
#define ADC0_ADCCFG_ADICLK_1           	BIT1
#define ADC0_ADCCFG_ADICLK_0           	BIT0

// ADC0_ADCSC1B Bit-Fields:
#define ADC0_ADCSC1B_COCO              	BIT7
#define ADC0_ADCSC1B_AIEN              	BIT6
#define ADC0_ADCSC1B_ADCO              	BIT5
#define ADC0_ADCSC1B_ADCH              	(BIT4+BIT3+BIT2+BIT1+BIT0)
#define ADC0_ADCSC1B_ADCH_4            	BIT4
#define ADC0_ADCSC1B_ADCH_3            	BIT3
#define ADC0_ADCSC1B_ADCH_2            	BIT2
#define ADC0_ADCSC1B_ADCH_1            	BIT1
#define ADC0_ADCSC1B_ADCH_0            	BIT0

// ADC0_ADCRA Bit-Fields:
#define ADC0_ADCRA_ADR11               	BIT14
#define ADC0_ADCRA_ADR10               	BIT13
#define ADC0_ADCRA_ADR9                	BIT12
#define ADC0_ADCRA_ADR8                	BIT11
#define ADC0_ADCRA_ADR7                	BIT10
#define ADC0_ADCRA_ADR6                	BIT9
#define ADC0_ADCRA_ADR5                	BIT8
#define ADC0_ADCRA_ADR4                	BIT7
#define ADC0_ADCRA_ADR3                	BIT6
#define ADC0_ADCRA_ADR2                	BIT5
#define ADC0_ADCRA_ADR1                	BIT4
#define ADC0_ADCRA_ADR0                	BIT3

// ADC0_ADCRB Bit-Fields:
#define ADC0_ADCRB_ADR11               	BIT14
#define ADC0_ADCRB_ADR10               	BIT13
#define ADC0_ADCRB_ADR9                	BIT12
#define ADC0_ADCRB_ADR8                	BIT11
#define ADC0_ADCRB_ADR7                	BIT10
#define ADC0_ADCRB_ADR6                	BIT9
#define ADC0_ADCRB_ADR5                	BIT8
#define ADC0_ADCRB_ADR4                	BIT7
#define ADC0_ADCRB_ADR3                	BIT6
#define ADC0_ADCRB_ADR2                	BIT5
#define ADC0_ADCRB_ADR1                	BIT4
#define ADC0_ADCRB_ADR0                	BIT3

///////////////////////////////////////////////////////////////////////////////////
// ADC1 Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// ADC1_ADCSC1A Bit-Fields:
#define ADC1_ADCSC1A_COCO              	BIT7
#define ADC1_ADCSC1A_AIEN              	BIT6
#define ADC1_ADCSC1A_ADCO              	BIT5
#define ADC1_ADCSC1A_ADCH              	(BIT4+BIT3+BIT2+BIT1+BIT0)
#define ADC1_ADCSC1A_ADCH_4            	BIT4
#define ADC1_ADCSC1A_ADCH_3            	BIT3
#define ADC1_ADCSC1A_ADCH_2            	BIT2
#define ADC1_ADCSC1A_ADCH_1            	BIT1
#define ADC1_ADCSC1A_ADCH_0            	BIT0

// ADC1_ADCSC2 Bit-Fields:
#define ADC1_ADCSC2_ADACT              	BIT7
#define ADC1_ADCSC2_ADTRG              	BIT6
#define ADC1_ADCSC2_ECC                	BIT2
#define ADC1_ADCSC2_REFSEL             	(BIT1+BIT0)
#define ADC1_ADCSC2_REFSEL_1           	BIT1
#define ADC1_ADCSC2_REFSEL_0           	BIT0

// ADC1_ADCCFG Bit-Fields:
#define ADC1_ADCCFG_ADLPC              	BIT7
#define ADC1_ADCCFG_ADIV               	(BIT6+BIT5)
#define ADC1_ADCCFG_ADIV_1             	BIT6
#define ADC1_ADCCFG_ADIV_0             	BIT5
#define ADC1_ADCCFG_ADLSMP             	BIT4
#define ADC1_ADCCFG_MODE               	(BIT3+BIT2)
#define ADC1_ADCCFG_MODE_1             	BIT3
#define ADC1_ADCCFG_MODE_0             	BIT2
#define ADC1_ADCCFG_ADICLK             	(BIT1+BIT0)
#define ADC1_ADCCFG_ADICLK_1           	BIT1
#define ADC1_ADCCFG_ADICLK_0           	BIT0

// ADC1_ADCSC1B Bit-Fields:
#define ADC1_ADCSC1B_COCO              	BIT7
#define ADC1_ADCSC1B_AIEN              	BIT6
#define ADC1_ADCSC1B_ADCO              	BIT5
#define ADC1_ADCSC1B_ADCH              	(BIT4+BIT3+BIT2+BIT1+BIT0)
#define ADC1_ADCSC1B_ADCH_4            	BIT4
#define ADC1_ADCSC1B_ADCH_3            	BIT3
#define ADC1_ADCSC1B_ADCH_2            	BIT2
#define ADC1_ADCSC1B_ADCH_1            	BIT1
#define ADC1_ADCSC1B_ADCH_0            	BIT0

// ADC1_ADCRA Bit-Fields:
#define ADC1_ADCRA_ADR11               	BIT14
#define ADC1_ADCRA_ADR10               	BIT13
#define ADC1_ADCRA_ADR9                	BIT12
#define ADC1_ADCRA_ADR8                	BIT11
#define ADC1_ADCRA_ADR7                	BIT10
#define ADC1_ADCRA_ADR6                	BIT9
#define ADC1_ADCRA_ADR5                	BIT8
#define ADC1_ADCRA_ADR4                	BIT7
#define ADC1_ADCRA_ADR3                	BIT6
#define ADC1_ADCRA_ADR2                	BIT5
#define ADC1_ADCRA_ADR1                	BIT4
#define ADC1_ADCRA_ADR0                	BIT3

// ADC1_ADCRB Bit-Fields:
#define ADC1_ADCRB_ADR11               	BIT14
#define ADC1_ADCRB_ADR10               	BIT13
#define ADC1_ADCRB_ADR9                	BIT12
#define ADC1_ADCRB_ADR8                	BIT11
#define ADC1_ADCRB_ADR7                	BIT10
#define ADC1_ADCRB_ADR6                	BIT9
#define ADC1_ADCRB_ADR5                	BIT8
#define ADC1_ADCRB_ADR4                	BIT7
#define ADC1_ADCRB_ADR3                	BIT6
#define ADC1_ADCRB_ADR2                	BIT5
#define ADC1_ADCRB_ADR1                	BIT4
#define ADC1_ADCRB_ADR0                	BIT3

///////////////////////////////////////////////////////////////////////////////////
// PGA0 Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// PGA0_CNTL0 Bit-Fields:
#define PGA0_CNTL0_TM                  	BIT7
#define PGA0_CNTL0_GAINSEL             	(BIT6+BIT5+BIT4+BIT3+BIT2)
#define PGA0_CNTL0_GAINSEL_4           	BIT6
#define PGA0_CNTL0_GAINSEL_3           	BIT5
#define PGA0_CNTL0_GAINSEL_2           	BIT4
#define PGA0_CNTL0_GAINSEL_1           	BIT3
#define PGA0_CNTL0_GAINSEL_0           	BIT2
#define PGA0_CNTL0_LP                  	BIT1
#define PGA0_CNTL0_EN                  	BIT0

// PGA0_CNTL1 Bit-Fields:
#define PGA0_CNTL1_BP                  	BIT5
#define PGA0_CNTL1_CALMODE             	(BIT4+BIT3)
#define PGA0_CNTL1_CALMODE_1           	BIT4
#define PGA0_CNTL1_CALMODE_0           	BIT3
#define PGA0_CNTL1_CPD                 	(BIT2+BIT1+BIT0)
#define PGA0_CNTL1_CPD_2               	BIT2
#define PGA0_CNTL1_CPD_1               	BIT1
#define PGA0_CNTL1_CPD_0               	BIT0

// PGA0_CNTL2 Bit-Fields:
#define PGA0_CNTL2_SWTRIG              	BIT5
#define PGA0_CNTL2_NUM_CLK_GS          	(BIT4+BIT3+BIT2)
#define PGA0_CNTL2_NUM_CLK_GS_2        	BIT4
#define PGA0_CNTL2_NUM_CLK_GS_1        	BIT3
#define PGA0_CNTL2_NUM_CLK_GS_0        	BIT2
#define PGA0_CNTL2_ADIV                	(BIT1+BIT0)
#define PGA0_CNTL2_ADIV_1              	BIT1
#define PGA0_CNTL2_ADIV_0              	BIT0

// PGA0_STS Bit-Fields:
#define PGA0_STS_RUNNING               	BIT1
#define PGA0_STS_STCOMP                	BIT0

///////////////////////////////////////////////////////////////////////////////////
// PGA1 Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// PGA1_CNTL0 Bit-Fields:
#define PGA1_CNTL0_TM                  	BIT7
#define PGA1_CNTL0_GAINSEL             	(BIT6+BIT5+BIT4+BIT3+BIT2)
#define PGA1_CNTL0_GAINSEL_4           	BIT6
#define PGA1_CNTL0_GAINSEL_3           	BIT5
#define PGA1_CNTL0_GAINSEL_2           	BIT4
#define PGA1_CNTL0_GAINSEL_1           	BIT3
#define PGA1_CNTL0_GAINSEL_0           	BIT2
#define PGA1_CNTL0_LP                  	BIT1
#define PGA1_CNTL0_EN                  	BIT0

// PGA1_CNTL1 Bit-Fields:
#define PGA1_CNTL1_BP                  	BIT5
#define PGA1_CNTL1_CALMODE             	(BIT4+BIT3)
#define PGA1_CNTL1_CALMODE_1           	BIT4
#define PGA1_CNTL1_CALMODE_0           	BIT3
#define PGA1_CNTL1_CPD                 	(BIT2+BIT1+BIT0)
#define PGA1_CNTL1_CPD_2               	BIT2
#define PGA1_CNTL1_CPD_1               	BIT1
#define PGA1_CNTL1_CPD_0               	BIT0

// PGA1_CNTL2 Bit-Fields:
#define PGA1_CNTL2_SWTRIG              	BIT5
#define PGA1_CNTL2_NUM_CLK_GS          	(BIT4+BIT3+BIT2)
#define PGA1_CNTL2_NUM_CLK_GS_2        	BIT4
#define PGA1_CNTL2_NUM_CLK_GS_1        	BIT3
#define PGA1_CNTL2_NUM_CLK_GS_0        	BIT2
#define PGA1_CNTL2_ADIV                	(BIT1+BIT0)
#define PGA1_CNTL2_ADIV_1              	BIT1
#define PGA1_CNTL2_ADIV_0              	BIT0

// PGA1_STS Bit-Fields:
#define PGA1_STS_RUNNING               	BIT1
#define PGA1_STS_STCOMP                	BIT0

///////////////////////////////////////////////////////////////////////////////////
// SCI Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// SCI_RATE Bit-Fields:
#define SCI_RATE_SBR                   	(BIT15+BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3)
#define SCI_RATE_SBR_12                	BIT15
#define SCI_RATE_SBR_11                	BIT14
#define SCI_RATE_SBR_10                	BIT13
#define SCI_RATE_SBR_9                 	BIT12
#define SCI_RATE_SBR_8                 	BIT11
#define SCI_RATE_SBR_7                 	BIT10
#define SCI_RATE_SBR_6                 	BIT9
#define SCI_RATE_SBR_5                 	BIT8
#define SCI_RATE_SBR_4                 	BIT7
#define SCI_RATE_SBR_3                 	BIT6
#define SCI_RATE_SBR_2                 	BIT5
#define SCI_RATE_SBR_1                 	BIT4
#define SCI_RATE_SBR_0                 	BIT3
#define SCI_RATE_FRAC_SBR              	(BIT2+BIT1+BIT0)
#define SCI_RATE_FRAC_SBR_2            	BIT2
#define SCI_RATE_FRAC_SBR_1            	BIT1
#define SCI_RATE_FRAC_SBR_0            	BIT0

// SCI_CTRL1 Bit-Fields:
#define SCI_CTRL1_LOOP                 	BIT15
#define SCI_CTRL1_SWAI                 	BIT14
#define SCI_CTRL1_RSRC                 	BIT13
#define SCI_CTRL1_M                    	BIT12
#define SCI_CTRL1_WAKE                 	BIT11
#define SCI_CTRL1_POL                  	BIT10
#define SCI_CTRL1_PE                   	BIT9
#define SCI_CTRL1_PT                   	BIT8
#define SCI_CTRL1_TEIE                 	BIT7
#define SCI_CTRL1_TIIE                 	BIT6
#define SCI_CTRL1_RFIE                 	BIT5
#define SCI_CTRL1_REIE                 	BIT4
#define SCI_CTRL1_TE                   	BIT3
#define SCI_CTRL1_RE                   	BIT2
#define SCI_CTRL1_RWU                  	BIT1
#define SCI_CTRL1_SBK                  	BIT0

// SCI_CTRL2 Bit-Fields:
#define SCI_CTRL2_TFCNT                	(BIT15+BIT14+BIT13)
#define SCI_CTRL2_TFCNT_2              	BIT15
#define SCI_CTRL2_TFCNT_1              	BIT14
#define SCI_CTRL2_TFCNT_0              	BIT13
#define SCI_CTRL2_TFWM                 	(BIT12+BIT11)
#define SCI_CTRL2_TFWM_1               	BIT12
#define SCI_CTRL2_TFWM_0               	BIT11
#define SCI_CTRL2_RFCNT                	(BIT10+BIT9+BIT8)
#define SCI_CTRL2_RFCNT_2              	BIT10
#define SCI_CTRL2_RFCNT_1              	BIT9
#define SCI_CTRL2_RFCNT_0              	BIT8
#define SCI_CTRL2_RFWM                 	(BIT7+BIT6)
#define SCI_CTRL2_RFWM_1               	BIT7
#define SCI_CTRL2_RFWM_0               	BIT6
#define SCI_CTRL2_FIFO_EN              	BIT5
#define SCI_CTRL2_LIN_MODE             	BIT3
#define SCI_CTRL2_RIIE                 	BIT2
#define SCI_CTRL2_TDE                  	BIT1
#define SCI_CTRL2_RDE                  	BIT0

// SCI_STAT Bit-Fields:
#define SCI_STAT_TDRE                  	BIT15
#define SCI_STAT_TIDLE                 	BIT14
#define SCI_STAT_RDRF                  	BIT13
#define SCI_STAT_RIDLE                 	BIT12
#define SCI_STAT_OR                    	BIT11
#define SCI_STAT_NF                    	BIT10
#define SCI_STAT_FE                    	BIT9
#define SCI_STAT_PF                    	BIT8
#define SCI_STAT_LSE                   	BIT3
#define SCI_STAT_TDMA                  	BIT2
#define SCI_STAT_RDMA                  	BIT1
#define SCI_STAT_RAF                   	BIT0

// SCI_DATA Bit-Fields:
#define SCI_DATA_Receive_Transmit_Data 	(BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define SCI_DATA_Receive_Transmit_Data_9 	BIT9
#define SCI_DATA_Receive_Transmit_Data_8 	BIT8
#define SCI_DATA_Receive_Transmit_Data_7 	BIT7
#define SCI_DATA_Receive_Transmit_Data_6 	BIT6
#define SCI_DATA_Receive_Transmit_Data_5 	BIT5
#define SCI_DATA_Receive_Transmit_Data_4 	BIT4
#define SCI_DATA_Receive_Transmit_Data_3 	BIT3
#define SCI_DATA_Receive_Transmit_Data_2 	BIT2
#define SCI_DATA_Receive_Transmit_Data_1 	BIT1
#define SCI_DATA_Receive_Transmit_Data_0 	BIT0

///////////////////////////////////////////////////////////////////////////////////
// SPI Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// SPI_SCTRL Bit-Fields:
#define SPI_SCTRL_SPR                  	(BIT15+BIT14+BIT13)
#define SPI_SCTRL_SPR_2                	BIT15
#define SPI_SCTRL_SPR_1                	BIT14
#define SPI_SCTRL_SPR_0                	BIT13
#define SPI_SCTRL_DSO                  	BIT12
#define SPI_SCTRL_EERIE                	BIT11
#define SPI_SCTRL_MODFEN               	BIT10
#define SPI_SCTRL_SPRIE                	BIT9
#define SPI_SCTRL_SPMSTR               	BIT8
#define SPI_SCTRL_CPOL                 	BIT7
#define SPI_SCTRL_CPHA                 	BIT6
#define SPI_SCTRL_SPE                  	BIT5
#define SPI_SCTRL_SPTIE                	BIT4
#define SPI_SCTRL_SPRF                 	BIT3
#define SPI_SCTRL_OVRF                 	BIT2
#define SPI_SCTRL_MODF                 	BIT1
#define SPI_SCTRL_SPTE                 	BIT0

// SPI_DSCTRL Bit-Fields:
#define SPI_DSCTRL_WOM                 	BIT15
#define SPI_DSCTRL_TDMAEN              	BIT14
#define SPI_DSCTRL_RDMAEN              	BIT13
#define SPI_DSCTRL_BD2X                	BIT12
#define SPI_DSCTRL_SSB_IN              	BIT11
#define SPI_DSCTRL_SSB_DATA            	BIT10
#define SPI_DSCTRL_SSB_ODM             	BIT9
#define SPI_DSCTRL_SSB_AUTO            	BIT8
#define SPI_DSCTRL_SSB_DDR             	BIT7
#define SPI_DSCTRL_SSB_STRB            	BIT6
#define SPI_DSCTRL_SSB_OVER            	BIT5
#define SPI_DSCTRL_DS                  	(BIT3+BIT2+BIT1+BIT0)
#define SPI_DSCTRL_DS_3                	BIT3
#define SPI_DSCTRL_DS_2                	BIT2
#define SPI_DSCTRL_DS_1                	BIT1
#define SPI_DSCTRL_DS_0                	BIT0

// SPI_DRCV Bit-Fields:
#define SPI_DRCV_R15                   	BIT15
#define SPI_DRCV_R14                   	BIT14
#define SPI_DRCV_R13                   	BIT13
#define SPI_DRCV_R12                   	BIT12
#define SPI_DRCV_R11                   	BIT11
#define SPI_DRCV_R10                   	BIT10
#define SPI_DRCV_R9                    	BIT9
#define SPI_DRCV_R8                    	BIT8
#define SPI_DRCV_R7                    	BIT7
#define SPI_DRCV_R6                    	BIT6
#define SPI_DRCV_R5                    	BIT5
#define SPI_DRCV_R4                    	BIT4
#define SPI_DRCV_R3                    	BIT3
#define SPI_DRCV_R2                    	BIT2
#define SPI_DRCV_R1                    	BIT1
#define SPI_DRCV_R0                    	BIT0

// SPI_DXMIT Bit-Fields:
#define SPI_DXMIT_T15                  	BIT15
#define SPI_DXMIT_T14                  	BIT14
#define SPI_DXMIT_T13                  	BIT13
#define SPI_DXMIT_T12                  	BIT12
#define SPI_DXMIT_T11                  	BIT11
#define SPI_DXMIT_T10                  	BIT10
#define SPI_DXMIT_T9                   	BIT9
#define SPI_DXMIT_T8                   	BIT8
#define SPI_DXMIT_T7                   	BIT7
#define SPI_DXMIT_T6                   	BIT6
#define SPI_DXMIT_T5                   	BIT5
#define SPI_DXMIT_T4                   	BIT4
#define SPI_DXMIT_T3                   	BIT3
#define SPI_DXMIT_T2                   	BIT2
#define SPI_DXMIT_T1                   	BIT1
#define SPI_DXMIT_T0                   	BIT0

///////////////////////////////////////////////////////////////////////////////////
// I2C Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// I2C_ADDR Bit-Fields:
#define I2C_ADDR_AD7                   	BIT7
#define I2C_ADDR_AD6                   	BIT6
#define I2C_ADDR_AD5                   	BIT5
#define I2C_ADDR_AD4                   	BIT4
#define I2C_ADDR_AD3                   	BIT3
#define I2C_ADDR_AD2                   	BIT2
#define I2C_ADDR_AD1                   	BIT1

// I2C_FREQDIV Bit-Fields:
#define I2C_FREQDIV_MULT               	(BIT7+BIT6)
#define I2C_FREQDIV_MULT_1             	BIT7
#define I2C_FREQDIV_MULT_0             	BIT6
#define I2C_FREQDIV_ICR                	(BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define I2C_FREQDIV_ICR_5              	BIT5
#define I2C_FREQDIV_ICR_4              	BIT4
#define I2C_FREQDIV_ICR_3              	BIT3
#define I2C_FREQDIV_ICR_2              	BIT2
#define I2C_FREQDIV_ICR_1              	BIT1
#define I2C_FREQDIV_ICR_0              	BIT0

// I2C_CR1 Bit-Fields:
#define I2C_CR1_IICEN                  	BIT7
#define I2C_CR1_IICIE                  	BIT6
#define I2C_CR1_MST                    	BIT5
#define I2C_CR1_TX                     	BIT4
#define I2C_CR1_TXAK                   	BIT3
#define I2C_CR1_RSTA                   	BIT2

// I2C_SR Bit-Fields:
#define I2C_SR_TCF                     	BIT7
#define I2C_SR_IAAS                    	BIT6
#define I2C_SR_BUSY                    	BIT5
#define I2C_SR_ARBL                    	BIT4
#define I2C_SR_SRW                     	BIT2
#define I2C_SR_IICIF                   	BIT1
#define I2C_SR_RXAK                    	BIT0

// I2C_DATA Bit-Fields:
#define I2C_DATA_DATA                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define I2C_DATA_DATA_7                	BIT7
#define I2C_DATA_DATA_6                	BIT6
#define I2C_DATA_DATA_5                	BIT5
#define I2C_DATA_DATA_4                	BIT4
#define I2C_DATA_DATA_3                	BIT3
#define I2C_DATA_DATA_2                	BIT2
#define I2C_DATA_DATA_1                	BIT1
#define I2C_DATA_DATA_0                	BIT0

// I2C_CR2 Bit-Fields:
#define I2C_CR2_GCAEN                  	BIT7
#define I2C_CR2_ADEXT                  	BIT6
#define I2C_CR2_AD10                   	BIT2
#define I2C_CR2_AD9                    	BIT1
#define I2C_CR2_AD8                    	BIT0

// I2C_SMB_CSR Bit-Fields:
#define I2C_SMB_CSR_FACK               	BIT7
#define I2C_SMB_CSR_ALERTEN            	BIT6
#define I2C_SMB_CSR_SIICAEN            	BIT5
#define I2C_SMB_CSR_TCKSEL             	BIT4
#define I2C_SMB_CSR_SLTF               	BIT3
#define I2C_SMB_CSR_SHTF               	BIT2

// I2C_ADDR2 Bit-Fields:
#define I2C_ADDR2_SAD7                 	BIT7
#define I2C_ADDR2_SAD6                 	BIT6
#define I2C_ADDR2_SAD5                 	BIT5
#define I2C_ADDR2_SAD4                 	BIT4
#define I2C_ADDR2_SAD3                 	BIT3
#define I2C_ADDR2_SAD2                 	BIT2
#define I2C_ADDR2_SAD1                 	BIT1

// I2C_SLT1 Bit-Fields:
#define I2C_SLT1_SSLT7                 	BIT7
#define I2C_SLT1_SSLT6                 	BIT6
#define I2C_SLT1_SSLT5                 	BIT5
#define I2C_SLT1_SSLT4                 	BIT4
#define I2C_SLT1_SSLT3                 	BIT3
#define I2C_SLT1_SSLT2                 	BIT2
#define I2C_SLT1_SSLT1                 	BIT1
#define I2C_SLT1_SSLT0                 	BIT0

// I2C_SLT2 Bit-Fields:
#define I2C_SLT2_SSLT15                	BIT7
#define I2C_SLT2_SSLT14                	BIT6
#define I2C_SLT2_SSLT13                	BIT5
#define I2C_SLT2_SSLT12                	BIT4
#define I2C_SLT2_SSLT11                	BIT3
#define I2C_SLT2_SSLT10                	BIT2
#define I2C_SLT2_SSLT9                 	BIT1
#define I2C_SLT2_SSLT8                 	BIT0

///////////////////////////////////////////////////////////////////////////////////
// COP Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// COP_CTRL Bit-Fields:
#define COP_CTRL_PSS                   	(BIT9+BIT8)
#define COP_CTRL_PSS_1                 	BIT9
#define COP_CTRL_PSS_0                 	BIT8
#define COP_CTRL_CLKSEL                	(BIT6+BIT5)
#define COP_CTRL_CLKSEL_1              	BIT6
#define COP_CTRL_CLKSEL_0              	BIT5
#define COP_CTRL_CLOREN                	BIT4
#define COP_CTRL_CSEN                  	BIT3
#define COP_CTRL_CWEN                  	BIT2
#define COP_CTRL_CEN                   	BIT1
#define COP_CTRL_CWP                   	BIT0

// COP_TOUT Bit-Fields:
#define COP_TOUT_TIMEOUT               	0xFFFF

// COP_CNTR Bit-Fields:
#define COP_CNTR_COUNT_SERVICE         	0xFFFF

///////////////////////////////////////////////////////////////////////////////////
// OCCS Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// OCCS_CTRL Bit-Fields:
#define OCCS_CTRL_PLLIE1               	(BIT15+BIT14)
#define OCCS_CTRL_PLLIE1_1             	BIT15
#define OCCS_CTRL_PLLIE1_0             	BIT14
#define OCCS_CTRL_PLLIE0               	(BIT13+BIT12)
#define OCCS_CTRL_PLLIE0_1             	BIT13
#define OCCS_CTRL_PLLIE0_0             	BIT12
#define OCCS_CTRL_LOCIE                	BIT11
#define OCCS_CTRL_LCKON                	BIT7
#define OCCS_CTRL_PLLPD                	BIT4
#define OCCS_CTRL_PRECS                	BIT2
#define OCCS_CTRL_ZSRC                 	(BIT1+BIT0)
#define OCCS_CTRL_ZSRC_1               	BIT1
#define OCCS_CTRL_ZSRC_0               	BIT0

// OCCS_DIVBY Bit-Fields:
#define OCCS_DIVBY_LORTP               	(BIT15+BIT14+BIT13+BIT12)
#define OCCS_DIVBY_LORTP_3             	BIT15
#define OCCS_DIVBY_LORTP_2             	BIT14
#define OCCS_DIVBY_LORTP_1             	BIT13
#define OCCS_DIVBY_LORTP_0             	BIT12
#define OCCS_DIVBY_COD                 	(BIT11+BIT10+BIT9+BIT8)
#define OCCS_DIVBY_COD_3               	BIT11
#define OCCS_DIVBY_COD_2               	BIT10
#define OCCS_DIVBY_COD_1               	BIT9
#define OCCS_DIVBY_COD_0               	BIT8

// OCCS_STAT Bit-Fields:
#define OCCS_STAT_LOLI1                	BIT15
#define OCCS_STAT_LOLI0                	BIT14
#define OCCS_STAT_LOCI                 	BIT13
#define OCCS_STAT_LCK1                 	BIT6
#define OCCS_STAT_LCK0                 	BIT5
#define OCCS_STAT_PLLPDN               	BIT4
#define OCCS_STAT_COSC_RDY             	BIT2
#define OCCS_STAT_ZSRCS                	(BIT1+BIT0)
#define OCCS_STAT_ZSRCS_1              	BIT1
#define OCCS_STAT_ZSRCS_0              	BIT0

// OCCS_TESTR Bit-Fields:
#define OCCS_TESTR_TPLLREF             	BIT7
#define OCCS_TESTR_TFDBK               	BIT5
#define OCCS_TESTR_TFREF               	BIT4
#define OCCS_TESTR_FLOCI               	BIT3
#define OCCS_TESTR_FLOLI1              	BIT2
#define OCCS_TESTR_FLOLI0              	BIT1
#define OCCS_TESTR_TM                  	BIT0

// OCCS_OCTRL Bit-Fields:
#define OCCS_OCTRL_ROPD                	BIT15
#define OCCS_OCTRL_ROSB                	BIT14
#define OCCS_OCTRL_COHL                	BIT13
#define OCCS_OCTRL_CLK_MODE            	BIT12
#define OCCS_OCTRL_RANGE               	BIT11
#define OCCS_OCTRL_EXT_SEL             	BIT10
#define OCCS_OCTRL_TRIM                	(BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define OCCS_OCTRL_TRIM_9              	BIT9
#define OCCS_OCTRL_TRIM_8              	BIT8
#define OCCS_OCTRL_TRIM_7              	BIT7
#define OCCS_OCTRL_TRIM_6              	BIT6
#define OCCS_OCTRL_TRIM_5              	BIT5
#define OCCS_OCTRL_TRIM_4              	BIT4
#define OCCS_OCTRL_TRIM_3              	BIT3
#define OCCS_OCTRL_TRIM_2              	BIT2
#define OCCS_OCTRL_TRIM_1              	BIT1
#define OCCS_OCTRL_TRIM_0              	BIT0

// OCCS_CLKCHKR Bit-Fields:
#define OCCS_CLKCHKR_CHK_ENA           	BIT15
#define OCCS_CLKCHKR_REFERENCE_CNT     	(BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define OCCS_CLKCHKR_REFERENCE_CNT_14  	BIT14
#define OCCS_CLKCHKR_REFERENCE_CNT_13  	BIT13
#define OCCS_CLKCHKR_REFERENCE_CNT_12  	BIT12
#define OCCS_CLKCHKR_REFERENCE_CNT_11  	BIT11
#define OCCS_CLKCHKR_REFERENCE_CNT_10  	BIT10
#define OCCS_CLKCHKR_REFERENCE_CNT_9   	BIT9
#define OCCS_CLKCHKR_REFERENCE_CNT_8   	BIT8
#define OCCS_CLKCHKR_REFERENCE_CNT_7   	BIT7
#define OCCS_CLKCHKR_REFERENCE_CNT_6   	BIT6
#define OCCS_CLKCHKR_REFERENCE_CNT_5   	BIT5
#define OCCS_CLKCHKR_REFERENCE_CNT_4   	BIT4
#define OCCS_CLKCHKR_REFERENCE_CNT_3   	BIT3
#define OCCS_CLKCHKR_REFERENCE_CNT_2   	BIT2
#define OCCS_CLKCHKR_REFERENCE_CNT_1   	BIT1
#define OCCS_CLKCHKR_REFERENCE_CNT_0   	BIT0

// OCCS_CLKCHKT Bit-Fields:
#define OCCS_CLKCHKT_TARGET_CNT        	(BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define OCCS_CLKCHKT_TARGET_CNT_6      	BIT6
#define OCCS_CLKCHKT_TARGET_CNT_5      	BIT5
#define OCCS_CLKCHKT_TARGET_CNT_4      	BIT4
#define OCCS_CLKCHKT_TARGET_CNT_3      	BIT3
#define OCCS_CLKCHKT_TARGET_CNT_2      	BIT2
#define OCCS_CLKCHKT_TARGET_CNT_1      	BIT1
#define OCCS_CLKCHKT_TARGET_CNT_0      	BIT0

// OCCS_PROT Bit-Fields:
#define OCCS_PROT_FRQEP                	(BIT5+BIT4)
#define OCCS_PROT_FRQEP_1              	BIT5
#define OCCS_PROT_FRQEP_0              	BIT4
#define OCCS_PROT_OSCEP                	(BIT3+BIT2)
#define OCCS_PROT_OSCEP_1              	BIT3
#define OCCS_PROT_OSCEP_0              	BIT2
#define OCCS_PROT_PLLEP                	(BIT1+BIT0)
#define OCCS_PROT_PLLEP_1              	BIT1
#define OCCS_PROT_PLLEP_0              	BIT0

///////////////////////////////////////////////////////////////////////////////////
// GPIOA Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// GPIOA_PUR Bit-Fields:
#define GPIOA_PUR_PUR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_PUR_PUR_7                	BIT7
#define GPIOA_PUR_PUR_6                	BIT6
#define GPIOA_PUR_PUR_5                	BIT5
#define GPIOA_PUR_PUR_4                	BIT4
#define GPIOA_PUR_PUR_3                	BIT3
#define GPIOA_PUR_PUR_2                	BIT2
#define GPIOA_PUR_PUR_1                	BIT1
#define GPIOA_PUR_PUR_0                	BIT0

// GPIOA_DR Bit-Fields:
#define GPIOA_DR_DR                    	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_DR_DR_7                  	BIT7
#define GPIOA_DR_DR_6                  	BIT6
#define GPIOA_DR_DR_5                  	BIT5
#define GPIOA_DR_DR_4                  	BIT4
#define GPIOA_DR_DR_3                  	BIT3
#define GPIOA_DR_DR_2                  	BIT2
#define GPIOA_DR_DR_1                  	BIT1
#define GPIOA_DR_DR_0                  	BIT0

// GPIOA_DDR Bit-Fields:
#define GPIOA_DDR_DDR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_DDR_DDR_7                	BIT7
#define GPIOA_DDR_DDR_6                	BIT6
#define GPIOA_DDR_DDR_5                	BIT5
#define GPIOA_DDR_DDR_4                	BIT4
#define GPIOA_DDR_DDR_3                	BIT3
#define GPIOA_DDR_DDR_2                	BIT2
#define GPIOA_DDR_DDR_1                	BIT1
#define GPIOA_DDR_DDR_0                	BIT0

// GPIOA_PER Bit-Fields:
#define GPIOA_PER_PER                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_PER_PER_7                	BIT7
#define GPIOA_PER_PER_6                	BIT6
#define GPIOA_PER_PER_5                	BIT5
#define GPIOA_PER_PER_4                	BIT4
#define GPIOA_PER_PER_3                	BIT3
#define GPIOA_PER_PER_2                	BIT2
#define GPIOA_PER_PER_1                	BIT1
#define GPIOA_PER_PER_0                	BIT0

// GPIOA_IENR Bit-Fields:
#define GPIOA_IENR_IENR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_IENR_IENR_7              	BIT7
#define GPIOA_IENR_IENR_6              	BIT6
#define GPIOA_IENR_IENR_5              	BIT5
#define GPIOA_IENR_IENR_4              	BIT4
#define GPIOA_IENR_IENR_3              	BIT3
#define GPIOA_IENR_IENR_2              	BIT2
#define GPIOA_IENR_IENR_1              	BIT1
#define GPIOA_IENR_IENR_0              	BIT0

// GPIOA_IPOLR Bit-Fields:
#define GPIOA_IPOLR_IPOLR              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_IPOLR_IPOLR_7            	BIT7
#define GPIOA_IPOLR_IPOLR_6            	BIT6
#define GPIOA_IPOLR_IPOLR_5            	BIT5
#define GPIOA_IPOLR_IPOLR_4            	BIT4
#define GPIOA_IPOLR_IPOLR_3            	BIT3
#define GPIOA_IPOLR_IPOLR_2            	BIT2
#define GPIOA_IPOLR_IPOLR_1            	BIT1
#define GPIOA_IPOLR_IPOLR_0            	BIT0

// GPIOA_IPR Bit-Fields:
#define GPIOA_IPR_IPR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_IPR_IPR_7                	BIT7
#define GPIOA_IPR_IPR_6                	BIT6
#define GPIOA_IPR_IPR_5                	BIT5
#define GPIOA_IPR_IPR_4                	BIT4
#define GPIOA_IPR_IPR_3                	BIT3
#define GPIOA_IPR_IPR_2                	BIT2
#define GPIOA_IPR_IPR_1                	BIT1
#define GPIOA_IPR_IPR_0                	BIT0

// GPIOA_IESR Bit-Fields:
#define GPIOA_IESR_IESR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_IESR_IESR_7              	BIT7
#define GPIOA_IESR_IESR_6              	BIT6
#define GPIOA_IESR_IESR_5              	BIT5
#define GPIOA_IESR_IESR_4              	BIT4
#define GPIOA_IESR_IESR_3              	BIT3
#define GPIOA_IESR_IESR_2              	BIT2
#define GPIOA_IESR_IESR_1              	BIT1
#define GPIOA_IESR_IESR_0              	BIT0

// GPIOA_RAWDATA Bit-Fields:
#define GPIOA_RAWDATA_RAWDATA          	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_RAWDATA_RAWDATA_7        	BIT7
#define GPIOA_RAWDATA_RAWDATA_6        	BIT6
#define GPIOA_RAWDATA_RAWDATA_5        	BIT5
#define GPIOA_RAWDATA_RAWDATA_4        	BIT4
#define GPIOA_RAWDATA_RAWDATA_3        	BIT3
#define GPIOA_RAWDATA_RAWDATA_2        	BIT2
#define GPIOA_RAWDATA_RAWDATA_1        	BIT1
#define GPIOA_RAWDATA_RAWDATA_0        	BIT0

// GPIOA_DRIVE Bit-Fields:
#define GPIOA_DRIVE_DRIVE              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_DRIVE_DRIVE_7            	BIT7
#define GPIOA_DRIVE_DRIVE_6            	BIT6
#define GPIOA_DRIVE_DRIVE_5            	BIT5
#define GPIOA_DRIVE_DRIVE_4            	BIT4
#define GPIOA_DRIVE_DRIVE_3            	BIT3
#define GPIOA_DRIVE_DRIVE_2            	BIT2
#define GPIOA_DRIVE_DRIVE_1            	BIT1
#define GPIOA_DRIVE_DRIVE_0            	BIT0

// GPIOA_IFE Bit-Fields:
#define GPIOA_IFE_IFE                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_IFE_IFE_7                	BIT7
#define GPIOA_IFE_IFE_6                	BIT6
#define GPIOA_IFE_IFE_5                	BIT5
#define GPIOA_IFE_IFE_4                	BIT4
#define GPIOA_IFE_IFE_3                	BIT3
#define GPIOA_IFE_IFE_2                	BIT2
#define GPIOA_IFE_IFE_1                	BIT1
#define GPIOA_IFE_IFE_0                	BIT0

// GPIOA_SLEW Bit-Fields:
#define GPIOA_SLEW_SLEW                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOA_SLEW_SLEW_7              	BIT7
#define GPIOA_SLEW_SLEW_6              	BIT6
#define GPIOA_SLEW_SLEW_5              	BIT5
#define GPIOA_SLEW_SLEW_4              	BIT4
#define GPIOA_SLEW_SLEW_3              	BIT3
#define GPIOA_SLEW_SLEW_2              	BIT2
#define GPIOA_SLEW_SLEW_1              	BIT1
#define GPIOA_SLEW_SLEW_0              	BIT0

///////////////////////////////////////////////////////////////////////////////////
// GPIOB Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// GPIOB_PUR Bit-Fields:
#define GPIOB_PUR_PUR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_PUR_PUR_7                	BIT7
#define GPIOB_PUR_PUR_6                	BIT6
#define GPIOB_PUR_PUR_5                	BIT5
#define GPIOB_PUR_PUR_4                	BIT4
#define GPIOB_PUR_PUR_3                	BIT3
#define GPIOB_PUR_PUR_2                	BIT2
#define GPIOB_PUR_PUR_1                	BIT1
#define GPIOB_PUR_PUR_0                	BIT0

// GPIOB_DR Bit-Fields:
#define GPIOB_DR_DR                    	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_DR_DR_7                  	BIT7
#define GPIOB_DR_DR_6                  	BIT6
#define GPIOB_DR_DR_5                  	BIT5
#define GPIOB_DR_DR_4                  	BIT4
#define GPIOB_DR_DR_3                  	BIT3
#define GPIOB_DR_DR_2                  	BIT2
#define GPIOB_DR_DR_1                  	BIT1
#define GPIOB_DR_DR_0                  	BIT0

// GPIOB_DDR Bit-Fields:
#define GPIOB_DDR_DDR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_DDR_DDR_7                	BIT7
#define GPIOB_DDR_DDR_6                	BIT6
#define GPIOB_DDR_DDR_5                	BIT5
#define GPIOB_DDR_DDR_4                	BIT4
#define GPIOB_DDR_DDR_3                	BIT3
#define GPIOB_DDR_DDR_2                	BIT2
#define GPIOB_DDR_DDR_1                	BIT1
#define GPIOB_DDR_DDR_0                	BIT0

// GPIOB_PER Bit-Fields:
#define GPIOB_PER_PER                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_PER_PER_7                	BIT7
#define GPIOB_PER_PER_6                	BIT6
#define GPIOB_PER_PER_5                	BIT5
#define GPIOB_PER_PER_4                	BIT4
#define GPIOB_PER_PER_3                	BIT3
#define GPIOB_PER_PER_2                	BIT2
#define GPIOB_PER_PER_1                	BIT1
#define GPIOB_PER_PER_0                	BIT0

// GPIOB_IENR Bit-Fields:
#define GPIOB_IENR_IENR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_IENR_IENR_7              	BIT7
#define GPIOB_IENR_IENR_6              	BIT6
#define GPIOB_IENR_IENR_5              	BIT5
#define GPIOB_IENR_IENR_4              	BIT4
#define GPIOB_IENR_IENR_3              	BIT3
#define GPIOB_IENR_IENR_2              	BIT2
#define GPIOB_IENR_IENR_1              	BIT1
#define GPIOB_IENR_IENR_0              	BIT0

// GPIOB_IPOLR Bit-Fields:
#define GPIOB_IPOLR_IPOLR              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_IPOLR_IPOLR_7            	BIT7
#define GPIOB_IPOLR_IPOLR_6            	BIT6
#define GPIOB_IPOLR_IPOLR_5            	BIT5
#define GPIOB_IPOLR_IPOLR_4            	BIT4
#define GPIOB_IPOLR_IPOLR_3            	BIT3
#define GPIOB_IPOLR_IPOLR_2            	BIT2
#define GPIOB_IPOLR_IPOLR_1            	BIT1
#define GPIOB_IPOLR_IPOLR_0            	BIT0

// GPIOB_IPR Bit-Fields:
#define GPIOB_IPR_IPR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_IPR_IPR_7                	BIT7
#define GPIOB_IPR_IPR_6                	BIT6
#define GPIOB_IPR_IPR_5                	BIT5
#define GPIOB_IPR_IPR_4                	BIT4
#define GPIOB_IPR_IPR_3                	BIT3
#define GPIOB_IPR_IPR_2                	BIT2
#define GPIOB_IPR_IPR_1                	BIT1
#define GPIOB_IPR_IPR_0                	BIT0

// GPIOB_IESR Bit-Fields:
#define GPIOB_IESR_IESR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_IESR_IESR_7              	BIT7
#define GPIOB_IESR_IESR_6              	BIT6
#define GPIOB_IESR_IESR_5              	BIT5
#define GPIOB_IESR_IESR_4              	BIT4
#define GPIOB_IESR_IESR_3              	BIT3
#define GPIOB_IESR_IESR_2              	BIT2
#define GPIOB_IESR_IESR_1              	BIT1
#define GPIOB_IESR_IESR_0              	BIT0

// GPIOB_RAWDATA Bit-Fields:
#define GPIOB_RAWDATA_RAWDATA          	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_RAWDATA_RAWDATA_7        	BIT7
#define GPIOB_RAWDATA_RAWDATA_6        	BIT6
#define GPIOB_RAWDATA_RAWDATA_5        	BIT5
#define GPIOB_RAWDATA_RAWDATA_4        	BIT4
#define GPIOB_RAWDATA_RAWDATA_3        	BIT3
#define GPIOB_RAWDATA_RAWDATA_2        	BIT2
#define GPIOB_RAWDATA_RAWDATA_1        	BIT1
#define GPIOB_RAWDATA_RAWDATA_0        	BIT0

// GPIOB_DRIVE Bit-Fields:
#define GPIOB_DRIVE_DRIVE              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_DRIVE_DRIVE_7            	BIT7
#define GPIOB_DRIVE_DRIVE_6            	BIT6
#define GPIOB_DRIVE_DRIVE_5            	BIT5
#define GPIOB_DRIVE_DRIVE_4            	BIT4
#define GPIOB_DRIVE_DRIVE_3            	BIT3
#define GPIOB_DRIVE_DRIVE_2            	BIT2
#define GPIOB_DRIVE_DRIVE_1            	BIT1
#define GPIOB_DRIVE_DRIVE_0            	BIT0

// GPIOB_IFE Bit-Fields:
#define GPIOB_IFE_IFE                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_IFE_IFE_7                	BIT7
#define GPIOB_IFE_IFE_6                	BIT6
#define GPIOB_IFE_IFE_5                	BIT5
#define GPIOB_IFE_IFE_4                	BIT4
#define GPIOB_IFE_IFE_3                	BIT3
#define GPIOB_IFE_IFE_2                	BIT2
#define GPIOB_IFE_IFE_1                	BIT1
#define GPIOB_IFE_IFE_0                	BIT0

// GPIOB_SLEW Bit-Fields:
#define GPIOB_SLEW_SLEW                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOB_SLEW_SLEW_7              	BIT7
#define GPIOB_SLEW_SLEW_6              	BIT6
#define GPIOB_SLEW_SLEW_5              	BIT5
#define GPIOB_SLEW_SLEW_4              	BIT4
#define GPIOB_SLEW_SLEW_3              	BIT3
#define GPIOB_SLEW_SLEW_2              	BIT2
#define GPIOB_SLEW_SLEW_1              	BIT1
#define GPIOB_SLEW_SLEW_0              	BIT0

///////////////////////////////////////////////////////////////////////////////////
// GPIOC Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// GPIOC_PUR Bit-Fields:
#define GPIOC_PUR_PUR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_PUR_PUR_7                	BIT7
#define GPIOC_PUR_PUR_6                	BIT6
#define GPIOC_PUR_PUR_5                	BIT5
#define GPIOC_PUR_PUR_4                	BIT4
#define GPIOC_PUR_PUR_3                	BIT3
#define GPIOC_PUR_PUR_2                	BIT2
#define GPIOC_PUR_PUR_1                	BIT1
#define GPIOC_PUR_PUR_0                	BIT0

// GPIOC_DR Bit-Fields:
#define GPIOC_DR_DR                    	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_DR_DR_7                  	BIT7
#define GPIOC_DR_DR_6                  	BIT6
#define GPIOC_DR_DR_5                  	BIT5
#define GPIOC_DR_DR_4                  	BIT4
#define GPIOC_DR_DR_3                  	BIT3
#define GPIOC_DR_DR_2                  	BIT2
#define GPIOC_DR_DR_1                  	BIT1
#define GPIOC_DR_DR_0                  	BIT0

// GPIOC_DDR Bit-Fields:
#define GPIOC_DDR_DDR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_DDR_DDR_7                	BIT7
#define GPIOC_DDR_DDR_6                	BIT6
#define GPIOC_DDR_DDR_5                	BIT5
#define GPIOC_DDR_DDR_4                	BIT4
#define GPIOC_DDR_DDR_3                	BIT3
#define GPIOC_DDR_DDR_2                	BIT2
#define GPIOC_DDR_DDR_1                	BIT1
#define GPIOC_DDR_DDR_0                	BIT0

// GPIOC_PER Bit-Fields:
#define GPIOC_PER_PER                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_PER_PER_7                	BIT7
#define GPIOC_PER_PER_6                	BIT6
#define GPIOC_PER_PER_5                	BIT5
#define GPIOC_PER_PER_4                	BIT4
#define GPIOC_PER_PER_3                	BIT3
#define GPIOC_PER_PER_2                	BIT2
#define GPIOC_PER_PER_1                	BIT1
#define GPIOC_PER_PER_0                	BIT0

// GPIOC_IENR Bit-Fields:
#define GPIOC_IENR_IENR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_IENR_IENR_7              	BIT7
#define GPIOC_IENR_IENR_6              	BIT6
#define GPIOC_IENR_IENR_5              	BIT5
#define GPIOC_IENR_IENR_4              	BIT4
#define GPIOC_IENR_IENR_3              	BIT3
#define GPIOC_IENR_IENR_2              	BIT2
#define GPIOC_IENR_IENR_1              	BIT1
#define GPIOC_IENR_IENR_0              	BIT0

// GPIOC_IPOLR Bit-Fields:
#define GPIOC_IPOLR_IPOLR              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_IPOLR_IPOLR_7            	BIT7
#define GPIOC_IPOLR_IPOLR_6            	BIT6
#define GPIOC_IPOLR_IPOLR_5            	BIT5
#define GPIOC_IPOLR_IPOLR_4            	BIT4
#define GPIOC_IPOLR_IPOLR_3            	BIT3
#define GPIOC_IPOLR_IPOLR_2            	BIT2
#define GPIOC_IPOLR_IPOLR_1            	BIT1
#define GPIOC_IPOLR_IPOLR_0            	BIT0

// GPIOC_IPR Bit-Fields:
#define GPIOC_IPR_IPR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_IPR_IPR_7                	BIT7
#define GPIOC_IPR_IPR_6                	BIT6
#define GPIOC_IPR_IPR_5                	BIT5
#define GPIOC_IPR_IPR_4                	BIT4
#define GPIOC_IPR_IPR_3                	BIT3
#define GPIOC_IPR_IPR_2                	BIT2
#define GPIOC_IPR_IPR_1                	BIT1
#define GPIOC_IPR_IPR_0                	BIT0

// GPIOC_IESR Bit-Fields:
#define GPIOC_IESR_IESR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_IESR_IESR_7              	BIT7
#define GPIOC_IESR_IESR_6              	BIT6
#define GPIOC_IESR_IESR_5              	BIT5
#define GPIOC_IESR_IESR_4              	BIT4
#define GPIOC_IESR_IESR_3              	BIT3
#define GPIOC_IESR_IESR_2              	BIT2
#define GPIOC_IESR_IESR_1              	BIT1
#define GPIOC_IESR_IESR_0              	BIT0

// GPIOC_RAWDATA Bit-Fields:
#define GPIOC_RAWDATA_RAWDATA          	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_RAWDATA_RAWDATA_7        	BIT7
#define GPIOC_RAWDATA_RAWDATA_6        	BIT6
#define GPIOC_RAWDATA_RAWDATA_5        	BIT5
#define GPIOC_RAWDATA_RAWDATA_4        	BIT4
#define GPIOC_RAWDATA_RAWDATA_3        	BIT3
#define GPIOC_RAWDATA_RAWDATA_2        	BIT2
#define GPIOC_RAWDATA_RAWDATA_1        	BIT1
#define GPIOC_RAWDATA_RAWDATA_0        	BIT0

// GPIOC_DRIVE Bit-Fields:
#define GPIOC_DRIVE_DRIVE              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_DRIVE_DRIVE_7            	BIT7
#define GPIOC_DRIVE_DRIVE_6            	BIT6
#define GPIOC_DRIVE_DRIVE_5            	BIT5
#define GPIOC_DRIVE_DRIVE_4            	BIT4
#define GPIOC_DRIVE_DRIVE_3            	BIT3
#define GPIOC_DRIVE_DRIVE_2            	BIT2
#define GPIOC_DRIVE_DRIVE_1            	BIT1
#define GPIOC_DRIVE_DRIVE_0            	BIT0

// GPIOC_IFE Bit-Fields:
#define GPIOC_IFE_IFE                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_IFE_IFE_7                	BIT7
#define GPIOC_IFE_IFE_6                	BIT6
#define GPIOC_IFE_IFE_5                	BIT5
#define GPIOC_IFE_IFE_4                	BIT4
#define GPIOC_IFE_IFE_3                	BIT3
#define GPIOC_IFE_IFE_2                	BIT2
#define GPIOC_IFE_IFE_1                	BIT1
#define GPIOC_IFE_IFE_0                	BIT0

// GPIOC_SLEW Bit-Fields:
#define GPIOC_SLEW_SLEW                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOC_SLEW_SLEW_7              	BIT7
#define GPIOC_SLEW_SLEW_6              	BIT6
#define GPIOC_SLEW_SLEW_5              	BIT5
#define GPIOC_SLEW_SLEW_4              	BIT4
#define GPIOC_SLEW_SLEW_3              	BIT3
#define GPIOC_SLEW_SLEW_2              	BIT2
#define GPIOC_SLEW_SLEW_1              	BIT1
#define GPIOC_SLEW_SLEW_0              	BIT0

///////////////////////////////////////////////////////////////////////////////////
// GPIOD Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// GPIOD_PUR Bit-Fields:
#define GPIOD_PUR_PUR                  	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_PUR_PUR_3                	BIT3
#define GPIOD_PUR_PUR_2                	BIT2
#define GPIOD_PUR_PUR_1                	BIT1
#define GPIOD_PUR_PUR_0                	BIT0

// GPIOD_DR Bit-Fields:
#define GPIOD_DR_DR                    	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_DR_DR_3                  	BIT3
#define GPIOD_DR_DR_2                  	BIT2
#define GPIOD_DR_DR_1                  	BIT1
#define GPIOD_DR_DR_0                  	BIT0

// GPIOD_DDR Bit-Fields:
#define GPIOD_DDR_DDR                  	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_DDR_DDR_3                	BIT3
#define GPIOD_DDR_DDR_2                	BIT2
#define GPIOD_DDR_DDR_1                	BIT1
#define GPIOD_DDR_DDR_0                	BIT0

// GPIOD_PER Bit-Fields:
#define GPIOD_PER_PER                  	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_PER_PER_3                	BIT3
#define GPIOD_PER_PER_2                	BIT2
#define GPIOD_PER_PER_1                	BIT1
#define GPIOD_PER_PER_0                	BIT0

// GPIOD_IENR Bit-Fields:
#define GPIOD_IENR_IENR                	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_IENR_IENR_3              	BIT3
#define GPIOD_IENR_IENR_2              	BIT2
#define GPIOD_IENR_IENR_1              	BIT1
#define GPIOD_IENR_IENR_0              	BIT0

// GPIOD_IPOLR Bit-Fields:
#define GPIOD_IPOLR_IPOLR              	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_IPOLR_IPOLR_3            	BIT3
#define GPIOD_IPOLR_IPOLR_2            	BIT2
#define GPIOD_IPOLR_IPOLR_1            	BIT1
#define GPIOD_IPOLR_IPOLR_0            	BIT0

// GPIOD_IPR Bit-Fields:
#define GPIOD_IPR_IPR                  	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_IPR_IPR_3                	BIT3
#define GPIOD_IPR_IPR_2                	BIT2
#define GPIOD_IPR_IPR_1                	BIT1
#define GPIOD_IPR_IPR_0                	BIT0

// GPIOD_IESR Bit-Fields:
#define GPIOD_IESR_IESR                	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_IESR_IESR_3              	BIT3
#define GPIOD_IESR_IESR_2              	BIT2
#define GPIOD_IESR_IESR_1              	BIT1
#define GPIOD_IESR_IESR_0              	BIT0

// GPIOD_RAWDATA Bit-Fields:
#define GPIOD_RAWDATA_RAWDATA          	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_RAWDATA_RAWDATA_3        	BIT3
#define GPIOD_RAWDATA_RAWDATA_2        	BIT2
#define GPIOD_RAWDATA_RAWDATA_1        	BIT1
#define GPIOD_RAWDATA_RAWDATA_0        	BIT0

// GPIOD_DRIVE Bit-Fields:
#define GPIOD_DRIVE_DRIVE              	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_DRIVE_DRIVE_3            	BIT3
#define GPIOD_DRIVE_DRIVE_2            	BIT2
#define GPIOD_DRIVE_DRIVE_1            	BIT1
#define GPIOD_DRIVE_DRIVE_0            	BIT0

// GPIOD_IFE Bit-Fields:
#define GPIOD_IFE_IFE                  	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_IFE_IFE_3                	BIT3
#define GPIOD_IFE_IFE_2                	BIT2
#define GPIOD_IFE_IFE_1                	BIT1
#define GPIOD_IFE_IFE_0                	BIT0

// GPIOD_SLEW Bit-Fields:
#define GPIOD_SLEW_SLEW                	(BIT3+BIT2+BIT1+BIT0)
#define GPIOD_SLEW_SLEW_3              	BIT3
#define GPIOD_SLEW_SLEW_2              	BIT2
#define GPIOD_SLEW_SLEW_1              	BIT1
#define GPIOD_SLEW_SLEW_0              	BIT0

///////////////////////////////////////////////////////////////////////////////////
// GPIOE Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// GPIOE_PUR Bit-Fields:
#define GPIOE_PUR_PUR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_PUR_PUR_7                	BIT7
#define GPIOE_PUR_PUR_6                	BIT6
#define GPIOE_PUR_PUR_5                	BIT5
#define GPIOE_PUR_PUR_4                	BIT4
#define GPIOE_PUR_PUR_3                	BIT3
#define GPIOE_PUR_PUR_2                	BIT2
#define GPIOE_PUR_PUR_1                	BIT1
#define GPIOE_PUR_PUR_0                	BIT0

// GPIOE_DR Bit-Fields:
#define GPIOE_DR_DR                    	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_DR_DR_7                  	BIT7
#define GPIOE_DR_DR_6                  	BIT6
#define GPIOE_DR_DR_5                  	BIT5
#define GPIOE_DR_DR_4                  	BIT4
#define GPIOE_DR_DR_3                  	BIT3
#define GPIOE_DR_DR_2                  	BIT2
#define GPIOE_DR_DR_1                  	BIT1
#define GPIOE_DR_DR_0                  	BIT0

// GPIOE_DDR Bit-Fields:
#define GPIOE_DDR_DDR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_DDR_DDR_7                	BIT7
#define GPIOE_DDR_DDR_6                	BIT6
#define GPIOE_DDR_DDR_5                	BIT5
#define GPIOE_DDR_DDR_4                	BIT4
#define GPIOE_DDR_DDR_3                	BIT3
#define GPIOE_DDR_DDR_2                	BIT2
#define GPIOE_DDR_DDR_1                	BIT1
#define GPIOE_DDR_DDR_0                	BIT0

// GPIOE_PER Bit-Fields:
#define GPIOE_PER_PER                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_PER_PER_7                	BIT7
#define GPIOE_PER_PER_6                	BIT6
#define GPIOE_PER_PER_5                	BIT5
#define GPIOE_PER_PER_4                	BIT4
#define GPIOE_PER_PER_3                	BIT3
#define GPIOE_PER_PER_2                	BIT2
#define GPIOE_PER_PER_1                	BIT1
#define GPIOE_PER_PER_0                	BIT0

// GPIOE_IENR Bit-Fields:
#define GPIOE_IENR_IENR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_IENR_IENR_7              	BIT7
#define GPIOE_IENR_IENR_6              	BIT6
#define GPIOE_IENR_IENR_5              	BIT5
#define GPIOE_IENR_IENR_4              	BIT4
#define GPIOE_IENR_IENR_3              	BIT3
#define GPIOE_IENR_IENR_2              	BIT2
#define GPIOE_IENR_IENR_1              	BIT1
#define GPIOE_IENR_IENR_0              	BIT0

// GPIOE_IPOLR Bit-Fields:
#define GPIOE_IPOLR_IPOLR              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_IPOLR_IPOLR_7            	BIT7
#define GPIOE_IPOLR_IPOLR_6            	BIT6
#define GPIOE_IPOLR_IPOLR_5            	BIT5
#define GPIOE_IPOLR_IPOLR_4            	BIT4
#define GPIOE_IPOLR_IPOLR_3            	BIT3
#define GPIOE_IPOLR_IPOLR_2            	BIT2
#define GPIOE_IPOLR_IPOLR_1            	BIT1
#define GPIOE_IPOLR_IPOLR_0            	BIT0

// GPIOE_IPR Bit-Fields:
#define GPIOE_IPR_IPR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_IPR_IPR_7                	BIT7
#define GPIOE_IPR_IPR_6                	BIT6
#define GPIOE_IPR_IPR_5                	BIT5
#define GPIOE_IPR_IPR_4                	BIT4
#define GPIOE_IPR_IPR_3                	BIT3
#define GPIOE_IPR_IPR_2                	BIT2
#define GPIOE_IPR_IPR_1                	BIT1
#define GPIOE_IPR_IPR_0                	BIT0

// GPIOE_IESR Bit-Fields:
#define GPIOE_IESR_IESR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_IESR_IESR_7              	BIT7
#define GPIOE_IESR_IESR_6              	BIT6
#define GPIOE_IESR_IESR_5              	BIT5
#define GPIOE_IESR_IESR_4              	BIT4
#define GPIOE_IESR_IESR_3              	BIT3
#define GPIOE_IESR_IESR_2              	BIT2
#define GPIOE_IESR_IESR_1              	BIT1
#define GPIOE_IESR_IESR_0              	BIT0

// GPIOE_RAWDATA Bit-Fields:
#define GPIOE_RAWDATA_RAWDATA          	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_RAWDATA_RAWDATA_7        	BIT7
#define GPIOE_RAWDATA_RAWDATA_6        	BIT6
#define GPIOE_RAWDATA_RAWDATA_5        	BIT5
#define GPIOE_RAWDATA_RAWDATA_4        	BIT4
#define GPIOE_RAWDATA_RAWDATA_3        	BIT3
#define GPIOE_RAWDATA_RAWDATA_2        	BIT2
#define GPIOE_RAWDATA_RAWDATA_1        	BIT1
#define GPIOE_RAWDATA_RAWDATA_0        	BIT0

// GPIOE_DRIVE Bit-Fields:
#define GPIOE_DRIVE_DRIVE              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_DRIVE_DRIVE_7            	BIT7
#define GPIOE_DRIVE_DRIVE_6            	BIT6
#define GPIOE_DRIVE_DRIVE_5            	BIT5
#define GPIOE_DRIVE_DRIVE_4            	BIT4
#define GPIOE_DRIVE_DRIVE_3            	BIT3
#define GPIOE_DRIVE_DRIVE_2            	BIT2
#define GPIOE_DRIVE_DRIVE_1            	BIT1
#define GPIOE_DRIVE_DRIVE_0            	BIT0

// GPIOE_IFE Bit-Fields:
#define GPIOE_IFE_IFE                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_IFE_IFE_7                	BIT7
#define GPIOE_IFE_IFE_6                	BIT6
#define GPIOE_IFE_IFE_5                	BIT5
#define GPIOE_IFE_IFE_4                	BIT4
#define GPIOE_IFE_IFE_3                	BIT3
#define GPIOE_IFE_IFE_2                	BIT2
#define GPIOE_IFE_IFE_1                	BIT1
#define GPIOE_IFE_IFE_0                	BIT0

// GPIOE_SLEW Bit-Fields:
#define GPIOE_SLEW_SLEW                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define GPIOE_SLEW_SLEW_7              	BIT7
#define GPIOE_SLEW_SLEW_6              	BIT6
#define GPIOE_SLEW_SLEW_5              	BIT5
#define GPIOE_SLEW_SLEW_4              	BIT4
#define GPIOE_SLEW_SLEW_3              	BIT3
#define GPIOE_SLEW_SLEW_2              	BIT2
#define GPIOE_SLEW_SLEW_1              	BIT1
#define GPIOE_SLEW_SLEW_0              	BIT0

///////////////////////////////////////////////////////////////////////////////////
// GPIOF Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// GPIOF_PUR Bit-Fields:
#define GPIOF_PUR_PUR                  	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_PUR_PUR_3                	BIT3
#define GPIOF_PUR_PUR_2                	BIT2
#define GPIOF_PUR_PUR_1                	BIT1
#define GPIOF_PUR_PUR_0                	BIT0

// GPIOF_DR Bit-Fields:
#define GPIOF_DR_DR                    	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_DR_DR_3                  	BIT3
#define GPIOF_DR_DR_2                  	BIT2
#define GPIOF_DR_DR_1                  	BIT1
#define GPIOF_DR_DR_0                  	BIT0

// GPIOF_DDR Bit-Fields:
#define GPIOF_DDR_DDR                  	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_DDR_DDR_3                	BIT3
#define GPIOF_DDR_DDR_2                	BIT2
#define GPIOF_DDR_DDR_1                	BIT1
#define GPIOF_DDR_DDR_0                	BIT0

// GPIOF_PER Bit-Fields:
#define GPIOF_PER_PER                  	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_PER_PER_3                	BIT3
#define GPIOF_PER_PER_2                	BIT2
#define GPIOF_PER_PER_1                	BIT1
#define GPIOF_PER_PER_0                	BIT0

// GPIOF_IENR Bit-Fields:
#define GPIOF_IENR_IENR                	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_IENR_IENR_3              	BIT3
#define GPIOF_IENR_IENR_2              	BIT2
#define GPIOF_IENR_IENR_1              	BIT1
#define GPIOF_IENR_IENR_0              	BIT0

// GPIOF_IPOLR Bit-Fields:
#define GPIOF_IPOLR_IPOLR              	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_IPOLR_IPOLR_3            	BIT3
#define GPIOF_IPOLR_IPOLR_2            	BIT2
#define GPIOF_IPOLR_IPOLR_1            	BIT1
#define GPIOF_IPOLR_IPOLR_0            	BIT0

// GPIOF_IPR Bit-Fields:
#define GPIOF_IPR_IPR                  	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_IPR_IPR_3                	BIT3
#define GPIOF_IPR_IPR_2                	BIT2
#define GPIOF_IPR_IPR_1                	BIT1
#define GPIOF_IPR_IPR_0                	BIT0

// GPIOF_IESR Bit-Fields:
#define GPIOF_IESR_IESR                	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_IESR_IESR_3              	BIT3
#define GPIOF_IESR_IESR_2              	BIT2
#define GPIOF_IESR_IESR_1              	BIT1
#define GPIOF_IESR_IESR_0              	BIT0

// GPIOF_RAWDATA Bit-Fields:
#define GPIOF_RAWDATA_RAWDATA          	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_RAWDATA_RAWDATA_3        	BIT3
#define GPIOF_RAWDATA_RAWDATA_2        	BIT2
#define GPIOF_RAWDATA_RAWDATA_1        	BIT1
#define GPIOF_RAWDATA_RAWDATA_0        	BIT0

// GPIOF_DRIVE Bit-Fields:
#define GPIOF_DRIVE_DRIVE              	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_DRIVE_DRIVE_3            	BIT3
#define GPIOF_DRIVE_DRIVE_2            	BIT2
#define GPIOF_DRIVE_DRIVE_1            	BIT1
#define GPIOF_DRIVE_DRIVE_0            	BIT0

// GPIOF_IFE Bit-Fields:
#define GPIOF_IFE_IFE                  	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_IFE_IFE_3                	BIT3
#define GPIOF_IFE_IFE_2                	BIT2
#define GPIOF_IFE_IFE_1                	BIT1
#define GPIOF_IFE_IFE_0                	BIT0

// GPIOF_SLEW Bit-Fields:
#define GPIOF_SLEW_SLEW                	(BIT3+BIT2+BIT1+BIT0)
#define GPIOF_SLEW_SLEW_3              	BIT3
#define GPIOF_SLEW_SLEW_2              	BIT2
#define GPIOF_SLEW_SLEW_1              	BIT1
#define GPIOF_SLEW_SLEW_0              	BIT0

///////////////////////////////////////////////////////////////////////////////////
// SIM Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// SIM_CTRL Bit-Fields:
#define SIM_CTRL_Once_Ebl              	BIT5
#define SIM_CTRL_SW_Rst                	BIT4
#define SIM_CTRL_STOP_disable          	(BIT3+BIT2)
#define SIM_CTRL_STOP_disable_1        	BIT3
#define SIM_CTRL_STOP_disable_0        	BIT2
#define SIM_CTRL_WAIT_disable          	(BIT1+BIT0)
#define SIM_CTRL_WAIT_disable_1        	BIT1
#define SIM_CTRL_WAIT_disable_0        	BIT0

// SIM_RSTAT Bit-Fields:
#define SIM_RSTAT_SWR                  	BIT6
#define SIM_RSTAT_COP_CPU              	BIT5
#define SIM_RSTAT_COP_LOR              	BIT4
#define SIM_RSTAT_EXTR                 	BIT3
#define SIM_RSTAT_LVDR                 	BIT2
#define SIM_RSTAT_PPD                  	BIT1
#define SIM_RSTAT_POR                  	BIT0

// SIM_MSHID Bit-Fields:

// SIM_LSHID Bit-Fields:

// SIM_TEST Bit-Fields:
#define SIM_TEST_TRS                   	(BIT15+BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7)
#define SIM_TEST_TRS_8                 	BIT15
#define SIM_TEST_TRS_7                 	BIT14
#define SIM_TEST_TRS_6                 	BIT13
#define SIM_TEST_TRS_5                 	BIT12
#define SIM_TEST_TRS_4                 	BIT11
#define SIM_TEST_TRS_3                 	BIT10
#define SIM_TEST_TRS_2                 	BIT9
#define SIM_TEST_TRS_1                 	BIT8
#define SIM_TEST_TRS_0                 	BIT7
#define SIM_TEST_Test_INT              	BIT6
#define SIM_TEST_Test_STOP             	BIT5
#define SIM_TEST_Test_WAIT             	BIT4
#define SIM_TEST_Test_CLKO             	BIT3
#define SIM_TEST_PG_Obs                	BIT1
#define SIM_TEST_CLO_Obs               	BIT0

// SIM_CLKOUT Bit-Fields:
#define SIM_CLKOUT_CLKDIS1             	BIT13
#define SIM_CLKOUT_CLKOSEL1            	(BIT10+BIT9+BIT8)
#define SIM_CLKOUT_CLKOSEL1_2          	BIT10
#define SIM_CLKOUT_CLKOSEL1_1          	BIT9
#define SIM_CLKOUT_CLKOSEL1_0          	BIT8
#define SIM_CLKOUT_CLKDIS0             	BIT5
#define SIM_CLKOUT_CLKOSEL0            	(BIT4+BIT3+BIT2+BIT1+BIT0)
#define SIM_CLKOUT_CLKOSEL0_4          	BIT4
#define SIM_CLKOUT_CLKOSEL0_3          	BIT3
#define SIM_CLKOUT_CLKOSEL0_2          	BIT2
#define SIM_CLKOUT_CLKOSEL0_1          	BIT1
#define SIM_CLKOUT_CLKOSEL0_0          	BIT0

// SIM_PCR Bit-Fields:
#define SIM_PCR_TMR_CR                 	BIT15
#define SIM_PCR_PWM_CR                 	BIT13
#define SIM_PCR_SCI_CR                 	BIT12

// SIM_PCE Bit-Fields:
#define SIM_PCE_CMP2                   	BIT15
#define SIM_PCE_CMP1                   	BIT14
#define SIM_PCE_CMP0                   	BIT13
#define SIM_PCE_ADC1                   	BIT12
#define SIM_PCE_ADC0                   	BIT11
#define SIM_PCE_PGA1                   	BIT10
#define SIM_PCE_PGA0                   	BIT9
#define SIM_PCE_I2C                    	BIT8
#define SIM_PCE_SCI                    	BIT7
#define SIM_PCE_SPI                    	BIT6
#define SIM_PCE_PWM                    	BIT5
#define SIM_PCE_COP                    	BIT4
#define SIM_PCE_PDB                    	BIT3
#define SIM_PCE_PIT                    	BIT2
#define SIM_PCE_TA1                    	BIT1
#define SIM_PCE_TA0                    	BIT0

// SIM_SDR Bit-Fields:
#define SIM_SDR_CMP2                   	BIT15
#define SIM_SDR_CMP1                   	BIT14
#define SIM_SDR_CMP0                   	BIT13
#define SIM_SDR_ADC1                   	BIT12
#define SIM_SDR_ADC0                   	BIT11
#define SIM_SDR_PGA1                   	BIT10
#define SIM_SDR_PGA0                   	BIT9
#define SIM_SDR_I2C                    	BIT8
#define SIM_SDR_SCI                    	BIT7
#define SIM_SDR_SPI                    	BIT6
#define SIM_SDR_PWM                    	BIT5
#define SIM_SDR_COP                    	BIT4
#define SIM_SDR_PDB                    	BIT3
#define SIM_SDR_PIT                    	BIT2
#define SIM_SDR_TA1                    	BIT1
#define SIM_SDR_TA0                    	BIT0

// SIM_ISAL Bit-Fields:
#define SIM_ISAL_ADDR_15_6             	(BIT15+BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6)
#define SIM_ISAL_ADDR_15_6_9           	BIT15
#define SIM_ISAL_ADDR_15_6_8           	BIT14
#define SIM_ISAL_ADDR_15_6_7           	BIT13
#define SIM_ISAL_ADDR_15_6_6           	BIT12
#define SIM_ISAL_ADDR_15_6_5           	BIT11
#define SIM_ISAL_ADDR_15_6_4           	BIT10
#define SIM_ISAL_ADDR_15_6_3           	BIT9
#define SIM_ISAL_ADDR_15_6_2           	BIT8
#define SIM_ISAL_ADDR_15_6_1           	BIT7
#define SIM_ISAL_ADDR_15_6_0           	BIT6

// SIM_PROT Bit-Fields:
#define SIM_PROT_PCEP                  	(BIT3+BIT2)
#define SIM_PROT_PCEP_1                	BIT3
#define SIM_PROT_PCEP_0                	BIT2
#define SIM_PROT_GIPSP                 	(BIT1+BIT0)
#define SIM_PROT_GIPSP_1               	BIT1
#define SIM_PROT_GIPSP_0               	BIT0

// SIM_GPSA Bit-Fields:
#define SIM_GPSA_GPS_A6                	(BIT8+BIT7+BIT6)
#define SIM_GPSA_GPS_A6_2              	BIT8
#define SIM_GPSA_GPS_A6_1              	BIT7
#define SIM_GPSA_GPS_A6_0              	BIT6
#define SIM_GPSA_GPS_A5                	(BIT5+BIT4)
#define SIM_GPSA_GPS_A5_1              	BIT5
#define SIM_GPSA_GPS_A5_0              	BIT4
#define SIM_GPSA_GPS_A4                	(BIT3+BIT2)
#define SIM_GPSA_GPS_A4_1              	BIT3
#define SIM_GPSA_GPS_A4_0              	BIT2
#define SIM_GPSA_GPS_A3                	(BIT1+BIT0)
#define SIM_GPSA_GPS_A3_1              	BIT1
#define SIM_GPSA_GPS_A3_0              	BIT0

// SIM_GPSB0 Bit-Fields:
#define SIM_GPSB0_GPS_B5               	(BIT15+BIT14)
#define SIM_GPSB0_GPS_B5_1             	BIT15
#define SIM_GPSB0_GPS_B5_0             	BIT14
#define SIM_GPSB0_GPS_B4               	(BIT13+BIT12+BIT11)
#define SIM_GPSB0_GPS_B4_2             	BIT13
#define SIM_GPSB0_GPS_B4_1             	BIT12
#define SIM_GPSB0_GPS_B4_0             	BIT11
#define SIM_GPSB0_GPS_B3               	(BIT10+BIT9+BIT8)
#define SIM_GPSB0_GPS_B3_2             	BIT10
#define SIM_GPSB0_GPS_B3_1             	BIT9
#define SIM_GPSB0_GPS_B3_0             	BIT8
#define SIM_GPSB0_GPS_B2               	(BIT7+BIT6)
#define SIM_GPSB0_GPS_B2_1             	BIT7
#define SIM_GPSB0_GPS_B2_0             	BIT6
#define SIM_GPSB0_GPS_B1               	(BIT4+BIT3)
#define SIM_GPSB0_GPS_B1_1             	BIT4
#define SIM_GPSB0_GPS_B1_0             	BIT3
#define SIM_GPSB0_GPS_B0               	(BIT2+BIT1+BIT0)
#define SIM_GPSB0_GPS_B0_2             	BIT2
#define SIM_GPSB0_GPS_B0_1             	BIT1
#define SIM_GPSB0_GPS_B0_0             	BIT0

// SIM_GPSB1 Bit-Fields:
#define SIM_GPSB1_GPS_B7               	(BIT3+BIT2)
#define SIM_GPSB1_GPS_B7_1             	BIT3
#define SIM_GPSB1_GPS_B7_0             	BIT2
#define SIM_GPSB1_GPS_B6               	(BIT1+BIT0)
#define SIM_GPSB1_GPS_B6_1             	BIT1
#define SIM_GPSB1_GPS_B6_0             	BIT0

// SIM_GPSC Bit-Fields:
#define SIM_GPSC_GPS_C6                	BIT1
#define SIM_GPSC_GPS_C0                	BIT0

// SIM_GPSD Bit-Fields:
#define SIM_GPSD_GPS_D3                	(BIT8+BIT7)
#define SIM_GPSD_GPS_D3_1              	BIT8
#define SIM_GPSD_GPS_D3_0              	BIT7
#define SIM_GPSD_GPS_D2                	(BIT6+BIT5)
#define SIM_GPSD_GPS_D2_1              	BIT6
#define SIM_GPSD_GPS_D2_0              	BIT5
#define SIM_GPSD_GPS_D1                	(BIT4+BIT3)
#define SIM_GPSD_GPS_D1_1              	BIT4
#define SIM_GPSD_GPS_D1_0              	BIT3
#define SIM_GPSD_GPS_D0                	(BIT2+BIT1+BIT0)
#define SIM_GPSD_GPS_D0_2              	BIT2
#define SIM_GPSD_GPS_D0_1              	BIT1
#define SIM_GPSD_GPS_D0_0              	BIT0

// SIM_IPS0 Bit-Fields:
#define SIM_IPS0_IPS_FAULT3            	BIT11
#define SIM_IPS0_IPS_FAULT2            	BIT10
#define SIM_IPS0_IPS_FAULT1            	BIT9
#define SIM_IPS0_IPS_PSRC2             	(BIT8+BIT7+BIT6)
#define SIM_IPS0_IPS_PSRC2_2           	BIT8
#define SIM_IPS0_IPS_PSRC2_1           	BIT7
#define SIM_IPS0_IPS_PSRC2_0           	BIT6
#define SIM_IPS0_IPS_PSRC1             	(BIT5+BIT4+BIT3)
#define SIM_IPS0_IPS_PSRC1_2           	BIT5
#define SIM_IPS0_IPS_PSRC1_1           	BIT4
#define SIM_IPS0_IPS_PSRC1_0           	BIT3
#define SIM_IPS0_IPS_PSRC0             	(BIT2+BIT1+BIT0)
#define SIM_IPS0_IPS_PSRC0_2           	BIT2
#define SIM_IPS0_IPS_PSRC0_1           	BIT1
#define SIM_IPS0_IPS_PSRC0_0           	BIT0

// SIM_IPS1 Bit-Fields:
#define SIM_IPS1_IPS_C2_WS             	(BIT14+BIT13+BIT12)
#define SIM_IPS1_IPS_C2_WS_2           	BIT14
#define SIM_IPS1_IPS_C2_WS_1           	BIT13
#define SIM_IPS1_IPS_C2_WS_0           	BIT12
#define SIM_IPS1_IPS_C1_WS             	(BIT11+BIT10+BIT9)
#define SIM_IPS1_IPS_C1_WS_2           	BIT11
#define SIM_IPS1_IPS_C1_WS_1           	BIT10
#define SIM_IPS1_IPS_C1_WS_0           	BIT9
#define SIM_IPS1_IPS_C0_WS             	(BIT8+BIT7+BIT6)
#define SIM_IPS1_IPS_C0_WS_2           	BIT8
#define SIM_IPS1_IPS_C0_WS_1           	BIT7
#define SIM_IPS1_IPS_C0_WS_0           	BIT6
#define SIM_IPS1_IPS_T1                	(BIT5+BIT4+BIT3)
#define SIM_IPS1_IPS_T1_2              	BIT5
#define SIM_IPS1_IPS_T1_1              	BIT4
#define SIM_IPS1_IPS_T1_0              	BIT3
#define SIM_IPS1_IPS_T0                	(BIT2+BIT1+BIT0)
#define SIM_IPS1_IPS_T0_2              	BIT2
#define SIM_IPS1_IPS_T0_1              	BIT1
#define SIM_IPS1_IPS_T0_0              	BIT0

///////////////////////////////////////////////////////////////////////////////////
// PMC Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// PMC_SCR Bit-Fields:
#define PMC_SCR_OORF                   	BIT15
#define PMC_SCR_LVDF                   	BIT14
#define PMC_SCR_PPDF                   	BIT13
#define PMC_SCR_PORF                   	BIT12
#define PMC_SCR_OORIE                  	BIT11
#define PMC_SCR_LVDIE                  	BIT10
#define PMC_SCR_LVDRE                  	BIT9
#define PMC_SCR_PPDE                   	BIT8
#define PMC_SCR_LPR                    	BIT7
#define PMC_SCR_LPRS                   	BIT6
#define PMC_SCR_LPWUI                  	BIT5
#define PMC_SCR_BGBE                   	BIT4
#define PMC_SCR_LVDE                   	BIT3
#define PMC_SCR_LVLS                   	BIT2
#define PMC_SCR_PROT                   	(BIT1+BIT0)
#define PMC_SCR_PROT_1                 	BIT1
#define PMC_SCR_PROT_0                 	BIT0

// PMC_CR2 Bit-Fields:
#define PMC_CR2_LPO_EN                 	BIT8
#define PMC_CR2_LPO_TRIM               	(BIT7+BIT6+BIT5)
#define PMC_CR2_LPO_TRIM_2             	BIT7
#define PMC_CR2_LPO_TRIM_1             	BIT6
#define PMC_CR2_LPO_TRIM_0             	BIT5
#define PMC_CR2_TRIM                   	(BIT4+BIT3+BIT2+BIT1+BIT0)
#define PMC_CR2_TRIM_4                 	BIT4
#define PMC_CR2_TRIM_3                 	BIT3
#define PMC_CR2_TRIM_2                 	BIT2
#define PMC_CR2_TRIM_1                 	BIT1
#define PMC_CR2_TRIM_0                 	BIT0

// PMC_TESTSC Bit-Fields:
#define PMC_TESTSC_LVDS                	BIT7
#define PMC_TESTSC_LVWS                	BIT6
#define PMC_TESTSC_VRP                 	BIT4
#define PMC_TESTSC_PMCTE               	BIT2
#define PMC_TESTSC_LVDFRC              	BIT1

///////////////////////////////////////////////////////////////////////////////////
// CMP0 Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// CMP0_CR0 Bit-Fields:
#define CMP0_CR0_FILTER_CNT            	(BIT6+BIT5+BIT4)
#define CMP0_CR0_FILTER_CNT_2          	BIT6
#define CMP0_CR0_FILTER_CNT_1          	BIT5
#define CMP0_CR0_FILTER_CNT_0          	BIT4
#define CMP0_CR0_PMC                   	(BIT3+BIT2)
#define CMP0_CR0_PMC_1                 	BIT3
#define CMP0_CR0_PMC_0                 	BIT2
#define CMP0_CR0_MMC                   	(BIT1+BIT0)
#define CMP0_CR0_MMC_1                 	BIT1
#define CMP0_CR0_MMC_0                 	BIT0

// CMP0_CR1 Bit-Fields:
#define CMP0_CR1_SE                    	BIT7
#define CMP0_CR1_WE                    	BIT6
#define CMP0_CR1_PMODE                 	BIT4
#define CMP0_CR1_INV                   	BIT3
#define CMP0_CR1_COS                   	BIT2
#define CMP0_CR1_OPE                   	BIT1
#define CMP0_CR1_EN                    	BIT0

// CMP0_FPR Bit-Fields:
#define CMP0_FPR_FILT_PER              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define CMP0_FPR_FILT_PER_7            	BIT7
#define CMP0_FPR_FILT_PER_6            	BIT6
#define CMP0_FPR_FILT_PER_5            	BIT5
#define CMP0_FPR_FILT_PER_4            	BIT4
#define CMP0_FPR_FILT_PER_3            	BIT3
#define CMP0_FPR_FILT_PER_2            	BIT2
#define CMP0_FPR_FILT_PER_1            	BIT1
#define CMP0_FPR_FILT_PER_0            	BIT0

// CMP0_SCR Bit-Fields:
#define CMP0_SCR_IER                   	BIT4
#define CMP0_SCR_IEF                   	BIT3
#define CMP0_SCR_CFR                   	BIT2
#define CMP0_SCR_CFF                   	BIT1
#define CMP0_SCR_COUT                  	BIT0

///////////////////////////////////////////////////////////////////////////////////
// CMP1 Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// CMP1_CR0 Bit-Fields:
#define CMP1_CR0_FILTER_CNT            	(BIT6+BIT5+BIT4)
#define CMP1_CR0_FILTER_CNT_2          	BIT6
#define CMP1_CR0_FILTER_CNT_1          	BIT5
#define CMP1_CR0_FILTER_CNT_0          	BIT4
#define CMP1_CR0_PMC                   	(BIT3+BIT2)
#define CMP1_CR0_PMC_1                 	BIT3
#define CMP1_CR0_PMC_0                 	BIT2
#define CMP1_CR0_MMC                   	(BIT1+BIT0)
#define CMP1_CR0_MMC_1                 	BIT1
#define CMP1_CR0_MMC_0                 	BIT0

// CMP1_CR1 Bit-Fields:
#define CMP1_CR1_SE                    	BIT7
#define CMP1_CR1_WE                    	BIT6
#define CMP1_CR1_PMODE                 	BIT4
#define CMP1_CR1_INV                   	BIT3
#define CMP1_CR1_COS                   	BIT2
#define CMP1_CR1_OPE                   	BIT1
#define CMP1_CR1_EN                    	BIT0

// CMP1_FPR Bit-Fields:
#define CMP1_FPR_FILT_PER              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define CMP1_FPR_FILT_PER_7            	BIT7
#define CMP1_FPR_FILT_PER_6            	BIT6
#define CMP1_FPR_FILT_PER_5            	BIT5
#define CMP1_FPR_FILT_PER_4            	BIT4
#define CMP1_FPR_FILT_PER_3            	BIT3
#define CMP1_FPR_FILT_PER_2            	BIT2
#define CMP1_FPR_FILT_PER_1            	BIT1
#define CMP1_FPR_FILT_PER_0            	BIT0

// CMP1_SCR Bit-Fields:
#define CMP1_SCR_IER                   	BIT4
#define CMP1_SCR_IEF                   	BIT3
#define CMP1_SCR_CFR                   	BIT2
#define CMP1_SCR_CFF                   	BIT1
#define CMP1_SCR_COUT                  	BIT0

///////////////////////////////////////////////////////////////////////////////////
// CMP2 Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// CMP2_CR0 Bit-Fields:
#define CMP2_CR0_FILTER_CNT            	(BIT6+BIT5+BIT4)
#define CMP2_CR0_FILTER_CNT_2          	BIT6
#define CMP2_CR0_FILTER_CNT_1          	BIT5
#define CMP2_CR0_FILTER_CNT_0          	BIT4
#define CMP2_CR0_PMC                   	(BIT3+BIT2)
#define CMP2_CR0_PMC_1                 	BIT3
#define CMP2_CR0_PMC_0                 	BIT2
#define CMP2_CR0_MMC                   	(BIT1+BIT0)
#define CMP2_CR0_MMC_1                 	BIT1
#define CMP2_CR0_MMC_0                 	BIT0

// CMP2_CR1 Bit-Fields:
#define CMP2_CR1_SE                    	BIT7
#define CMP2_CR1_WE                    	BIT6
#define CMP2_CR1_PMODE                 	BIT4
#define CMP2_CR1_INV                   	BIT3
#define CMP2_CR1_COS                   	BIT2
#define CMP2_CR1_OPE                   	BIT1
#define CMP2_CR1_EN                    	BIT0

// CMP2_FPR Bit-Fields:
#define CMP2_FPR_FILT_PER              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define CMP2_FPR_FILT_PER_7            	BIT7
#define CMP2_FPR_FILT_PER_6            	BIT6
#define CMP2_FPR_FILT_PER_5            	BIT5
#define CMP2_FPR_FILT_PER_4            	BIT4
#define CMP2_FPR_FILT_PER_3            	BIT3
#define CMP2_FPR_FILT_PER_2            	BIT2
#define CMP2_FPR_FILT_PER_1            	BIT1
#define CMP2_FPR_FILT_PER_0            	BIT0

// CMP2_SCR Bit-Fields:
#define CMP2_SCR_IER                   	BIT4
#define CMP2_SCR_IEF                   	BIT3
#define CMP2_SCR_CFR                   	BIT2
#define CMP2_SCR_CFF                   	BIT1
#define CMP2_SCR_COUT                  	BIT0

///////////////////////////////////////////////////////////////////////////////////
// PIT Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// PIT_CTRL Bit-Fields:
#define PIT_CTRL_PRESCALER             	(BIT6+BIT5+BIT4+BIT3)
#define PIT_CTRL_PRESCALER_3           	BIT6
#define PIT_CTRL_PRESCALER_2           	BIT5
#define PIT_CTRL_PRESCALER_1           	BIT4
#define PIT_CTRL_PRESCALER_0           	BIT3
#define PIT_CTRL_PRF                   	BIT2
#define PIT_CTRL_PRIE                  	BIT1
#define PIT_CTRL_CNT_EN                	BIT0

// PIT_MOD Bit-Fields:
#define PIT_MOD_MODULO_VALUE           	0xFFFF

// PIT_CNTR Bit-Fields:
#define PIT_CNTR_COUNTER_VALUE         	0xFFFF

///////////////////////////////////////////////////////////////////////////////////
// PDB Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// PDB_SCR Bit-Fields:
#define PDB_SCR_PRESCALAR              	(BIT15+BIT14+BIT13)
#define PDB_SCR_PRESCALAR_2            	BIT15
#define PDB_SCR_PRESCALAR_1            	BIT14
#define PDB_SCR_PRESCALAR_0            	BIT13
#define PDB_SCR_AOS                    	(BIT11+BIT10)
#define PDB_SCR_AOS_1                  	BIT11
#define PDB_SCR_AOS_0                  	BIT10
#define PDB_SCR_BOS                    	(BIT8+BIT7)
#define PDB_SCR_BOS_1                  	BIT8
#define PDB_SCR_BOS_0                  	BIT7
#define PDB_SCR_CONT                   	BIT6
#define PDB_SCR_SWTRIG                 	BIT5
#define PDB_SCR_TRIGSEL                	(BIT4+BIT3+BIT2)
#define PDB_SCR_TRIGSEL_2              	BIT4
#define PDB_SCR_TRIGSEL_1              	BIT3
#define PDB_SCR_TRIGSEL_0              	BIT2
#define PDB_SCR_ENA                    	BIT1
#define PDB_SCR_ENB                    	BIT0

// PDB_DELAYA Bit-Fields:
#define PDB_DELAYA_DELAYA              	0xFFFF

// PDB_DELAYB Bit-Fields:
#define PDB_DELAYB_DELAYB              	0xFFFF

// PDB_MOD Bit-Fields:
#define PDB_MOD_MOD                    	0xFFFF

// PDB_COUNT Bit-Fields:
#define PDB_COUNT_COUNT                	0xFFFF

///////////////////////////////////////////////////////////////////////////////////
// RTC Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// RTC_SC Bit-Fields:
#define RTC_SC_RTIF                    	BIT7
#define RTC_SC_RTCLKS                  	(BIT6+BIT5)
#define RTC_SC_RTCLKS_1                	BIT6
#define RTC_SC_RTCLKS_0                	BIT5
#define RTC_SC_RTIE                    	BIT4
#define RTC_SC_RTCPS                   	(BIT3+BIT2+BIT1+BIT0)
#define RTC_SC_RTCPS_3                 	BIT3
#define RTC_SC_RTCPS_2                 	BIT2
#define RTC_SC_RTCPS_1                 	BIT1
#define RTC_SC_RTCPS_0                 	BIT0

// RTC_CNT Bit-Fields:
#define RTC_CNT_RTCCNT                 	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define RTC_CNT_RTCCNT_7               	BIT7
#define RTC_CNT_RTCCNT_6               	BIT6
#define RTC_CNT_RTCCNT_5               	BIT5
#define RTC_CNT_RTCCNT_4               	BIT4
#define RTC_CNT_RTCCNT_3               	BIT3
#define RTC_CNT_RTCCNT_2               	BIT2
#define RTC_CNT_RTCCNT_1               	BIT1
#define RTC_CNT_RTCCNT_0               	BIT0

// RTC_MOD Bit-Fields:
#define RTC_MOD_RTCMOD                 	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define RTC_MOD_RTCMOD_7               	BIT7
#define RTC_MOD_RTCMOD_6               	BIT6
#define RTC_MOD_RTCMOD_5               	BIT5
#define RTC_MOD_RTCMOD_4               	BIT4
#define RTC_MOD_RTCMOD_3               	BIT3
#define RTC_MOD_RTCMOD_2               	BIT2
#define RTC_MOD_RTCMOD_1               	BIT1
#define RTC_MOD_RTCMOD_0               	BIT0

///////////////////////////////////////////////////////////////////////////////////
// HFM Peripheral Register Bit-Fields & Pointers
///////////////////////////////////////////////////////////////////////////////////

// FM_CLKDIV Bit-Fields:
#define FM_CLKDIV_DIVLD                	BIT7
#define FM_CLKDIV_PRDIV8               	BIT6
#define FM_CLKDIV_DIV                  	(BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define FM_CLKDIV_DIV_5                	BIT5
#define FM_CLKDIV_DIV_4                	BIT4
#define FM_CLKDIV_DIV_3                	BIT3
#define FM_CLKDIV_DIV_2                	BIT2
#define FM_CLKDIV_DIV_1                	BIT1
#define FM_CLKDIV_DIV_0                	BIT0

// FM_CNFG Bit-Fields:
#define FM_CNFG_LOCK                   	BIT10
#define FM_CNFG_AEIE                   	BIT8
#define FM_CNFG_CBEIE                  	BIT7
#define FM_CNFG_CCIE                   	BIT6
#define FM_CNFG_KEYACC                 	BIT5

// FM_TEST Bit-Fields:
#define FM_TEST_DIRECT                 	BIT0

// FM_SECHI Bit-Fields:
#define FM_SECHI_KEYEN                 	BIT15
#define FM_SECHI_SECSTAT               	BIT14

// FM_SECLO Bit-Fields:
#define FM_SECLO_SEC                   	(BIT1+BIT0)
#define FM_SECLO_SEC_1                 	BIT1
#define FM_SECLO_SEC_0                 	BIT0

// FM_MONITOR Bit-Fields:
#define FM_MONITOR_HFMMNTR             	0xFFFF

// FM_PROT Bit-Fields:
#define FM_PROT_PROTECT                	0xFFFF

// FM_TSTAT Bit-Fields:
#define FM_TSTAT_FAIL                  	BIT1
#define FM_TSTAT_DONE                  	BIT0

// FM_USTAT Bit-Fields:
#define FM_USTAT_CBEIF                 	BIT7
#define FM_USTAT_CCIF                  	BIT6
#define FM_USTAT_PVIOL                 	BIT5
#define FM_USTAT_ACCERR                	BIT4
#define FM_USTAT_BLANK                 	BIT2

// FM_CMD Bit-Fields:
#define FM_CMD_CMD                     	(BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
#define FM_CMD_CMD_6                   	BIT6
#define FM_CMD_CMD_5                   	BIT5
#define FM_CMD_CMD_4                   	BIT4
#define FM_CMD_CMD_3                   	BIT3
#define FM_CMD_CMD_2                   	BIT2
#define FM_CMD_CMD_1                   	BIT1
#define FM_CMD_CMD_0                   	BIT0

// FM_CONTROL Bit-Fields:
#define FM_CONTROL_TMR                 	BIT15
#define FM_CONTROL_ERASE               	BIT7
#define FM_CONTROL_PROG                	BIT6
#define FM_CONTROL_IFREN               	BIT5
#define FM_CONTROL_NVSTR               	BIT4
#define FM_CONTROL_XE                  	BIT3
#define FM_CONTROL_YE                  	BIT2
#define FM_CONTROL_SE                 	BIT1
#define FM_CONTROL_MAS1                	BIT0

// FM_ADDR Bit-Fields:
#define FM_ADDR_HFMADR                 	0xFFFF

// FM_DATA Bit-Fields:
#define FM_DATA_HFMDATA                	0xFFFF

// FM_OPT0 Bit-Fields:
#define FM_OPT0_IFR_OPT0               	0xFFFF

// FM_OPT1 Bit-Fields:
#define FM_OPT1_IFR_OPT1               	0xFFFF

// FM_MEM_SEL Bit-Fields:
#define FM_MEM_SEL_MEM_SEL             	(BIT3+BIT2+BIT1+BIT0)
#define FM_MEM_SEL_MEM_SEL_3           	BIT3
#define FM_MEM_SEL_MEM_SEL_2           	BIT2
#define FM_MEM_SEL_MEM_SEL_1           	BIT1
#define FM_MEM_SEL_MEM_SEL_0           	BIT0

// FM_TSTSIG Bit-Fields:
#define FM_TSTSIG_TST_AREA_SIG         	0xFFFF

///////////////////////////////////////////////////////////////////////////////////
// Begin Type 2 Register definitions.
///////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////
// TMR0 Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD COMPARISON_1                   : 16;
} _TMR0_COMP1;
#define sTMR0_COMP1      (*(_TMR0_COMP1 *) (0x00F000))

typedef struct {
	BITFIELD COMPARISON_2                   : 16;
} _TMR0_COMP2;
#define sTMR0_COMP2      (*(_TMR0_COMP2 *) (0x00F001))

typedef struct {
	BITFIELD CAPTURE                        : 16;
} _TMR0_CAPT;
#define sTMR0_CAPT       (*(_TMR0_CAPT *) (0x00F002))

typedef struct {
	BITFIELD LOAD                           : 16;
} _TMR0_LOAD;
#define sTMR0_LOAD       (*(_TMR0_LOAD *) (0x00F003))

typedef struct {
	BITFIELD HOLD                           : 16;
} _TMR0_HOLD;
#define sTMR0_HOLD       (*(_TMR0_HOLD *) (0x00F004))

typedef struct {
	BITFIELD COUNTER                        : 16;
} _TMR0_CNTR;
#define sTMR0_CNTR       (*(_TMR0_CNTR *) (0x00F005))

typedef struct {
	BITFIELD CM                             : 3;
	BITFIELD PCS                            : 4;
	BITFIELD SCS                            : 2;
	BITFIELD ONCE                           : 1;
	BITFIELD LENGTH                         : 1;
	BITFIELD DIR                            : 1;
	BITFIELD Co_INIT                        : 1;
	BITFIELD OM                             : 3;
} _TMR0_CTRL;
#define sTMR0_CTRL       (*(_TMR0_CTRL *) (0x00F006))

typedef struct {
	BITFIELD TCF                            : 1;
	BITFIELD TCFIE                          : 1;
	BITFIELD TOF                            : 1;
	BITFIELD TOFIE                          : 1;
	BITFIELD IEF                            : 1;
	BITFIELD IEFIE                          : 1;
	BITFIELD IPS                            : 1;
	BITFIELD INPUT                          : 1;
	BITFIELD CAPTURE_MODE                   : 2;
	BITFIELD MSTR                           : 1;
	BITFIELD EEOF                           : 1;
	BITFIELD VAL                            : 1;
	BITFIELD FORCE                          : 1;
	BITFIELD OPS                            : 1;
	BITFIELD OEN                            : 1;
} _TMR0_SCTRL;
#define sTMR0_SCTRL      (*(_TMR0_SCTRL *) (0x00F007))

typedef struct {
	BITFIELD COMPARATOR_LOAD_1              : 16;
} _TMR0_CMPLD1;
#define sTMR0_CMPLD1     (*(_TMR0_CMPLD1 *) (0x00F008))

typedef struct {
	BITFIELD COMPARATOR_LOAD_2              : 16;
} _TMR0_CMPLD2;
#define sTMR0_CMPLD2     (*(_TMR0_CMPLD2 *) (0x00F009))

typedef struct {
	BITFIELD DBG_EN                         : 2;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD TCF2EN                         : 1;
	BITFIELD TCF1EN                         : 1;
	BITFIELD TCF2                           : 1;
	BITFIELD TCF1                           : 1;
	BITFIELD CL2                            : 2;
	BITFIELD CL1                            : 2;
} _TMR0_CSCTRL;
#define sTMR0_CSCTRL     (*(_TMR0_CSCTRL *) (0x00F00A))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD FILT_CNT                       : 3;
	BITFIELD FILT_PER                       : 8;
} _TMR0_FILT;
#define sTMR0_FILT       (*(_TMR0_FILT *) (0x00F00B))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD ENBL                           : 2;
} _TMR_ENBL;
#define sTMR_ENBL        (*(_TMR_ENBL *) (0x00F00F))


///////////////////////////////////////////////////////////////////////////////////
// TMR1 Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD COMPARISON_1                   : 16;
} _TMR1_COMP1;
#define sTMR1_COMP1      (*(_TMR1_COMP1 *) (0x00F010))

typedef struct {
	BITFIELD COMPARISON_2                   : 16;
} _TMR1_COMP2;
#define sTMR1_COMP2      (*(_TMR1_COMP2 *) (0x00F011))

typedef struct {
	BITFIELD CAPTURE                        : 16;
} _TMR1_CAPT;
#define sTMR1_CAPT       (*(_TMR1_CAPT *) (0x00F012))

typedef struct {
	BITFIELD LOAD                           : 16;
} _TMR1_LOAD;
#define sTMR1_LOAD       (*(_TMR1_LOAD *) (0x00F013))

typedef struct {
	BITFIELD HOLD                           : 16;
} _TMR1_HOLD;
#define sTMR1_HOLD       (*(_TMR1_HOLD *) (0x00F014))

typedef struct {
	BITFIELD COUNTER                        : 16;
} _TMR1_CNTR;
#define sTMR1_CNTR       (*(_TMR1_CNTR *) (0x00F015))

typedef struct {
	BITFIELD CM                             : 3;
	BITFIELD PCS                            : 4;
	BITFIELD SCS                            : 2;
	BITFIELD ONCE                           : 1;
	BITFIELD LENGTH                         : 1;
	BITFIELD DIR                            : 1;
	BITFIELD Co_INIT                        : 1;
	BITFIELD OM                             : 3;
} _TMR1_CTRL;
#define sTMR1_CTRL       (*(_TMR1_CTRL *) (0x00F016))

typedef struct {
	BITFIELD TCF                            : 1;
	BITFIELD TCFIE                          : 1;
	BITFIELD TOF                            : 1;
	BITFIELD TOFIE                          : 1;
	BITFIELD IEF                            : 1;
	BITFIELD IEFIE                          : 1;
	BITFIELD IPS                            : 1;
	BITFIELD INPUT                          : 1;
	BITFIELD CAPTURE_MODE                   : 2;
	BITFIELD MSTR                           : 1;
	BITFIELD EEOF                           : 1;
	BITFIELD VAL                            : 1;
	BITFIELD FORCE                          : 1;
	BITFIELD OPS                            : 1;
	BITFIELD OEN                            : 1;
} _TMR1_SCTRL;
#define sTMR1_SCTRL      (*(_TMR1_SCTRL *) (0x00F017))

typedef struct {
	BITFIELD COMPARATOR_LOAD_1              : 16;
} _TMR1_CMPLD1;
#define sTMR1_CMPLD1     (*(_TMR1_CMPLD1 *) (0x00F018))

typedef struct {
	BITFIELD COMPARATOR_LOAD_2              : 16;
} _TMR1_CMPLD2;
#define sTMR1_CMPLD2     (*(_TMR1_CMPLD2 *) (0x00F019))

typedef struct {
	BITFIELD DBG_EN                         : 2;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD TCF2EN                         : 1;
	BITFIELD TCF1EN                         : 1;
	BITFIELD TCF2                           : 1;
	BITFIELD TCF1                           : 1;
	BITFIELD CL2                            : 2;
	BITFIELD CL1                            : 2;
} _TMR1_CSCTRL;
#define sTMR1_CSCTRL     (*(_TMR1_CSCTRL *) (0x00F01A))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD FILT_CNT                       : 3;
	BITFIELD FILT_PER                       : 8;
} _TMR1_FILT;
#define sTMR1_FILT       (*(_TMR1_FILT *) (0x00F01B))


///////////////////////////////////////////////////////////////////////////////////
// PWM Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD LDFQ                           : 4;
	BITFIELD HALF                           : 1;
	BITFIELD IPOL2                          : 1;
	BITFIELD IPOL1                          : 1;
	BITFIELD IPOL0                          : 1;
	BITFIELD PRSC                           : 2;
	BITFIELD PWMRIE                         : 1;
	BITFIELD PWMF                           : 1;
	BITFIELD ISENS                          : 2;
	BITFIELD LDOK                           : 1;
	BITFIELD PWMEN                          : 1;
} _PWM_CTRL;
#define sPWM_CTRL        (*(_PWM_CTRL *) (0x00F020))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD FPOL3                          : 1;
	BITFIELD FPOL2                          : 1;
	BITFIELD FPOL1                          : 1;
	BITFIELD FPOL0                          : 1;
	BITFIELD FIE3                           : 1;
	BITFIELD FMODE3                         : 1;
	BITFIELD FIE2                           : 1;
	BITFIELD FMODE2                         : 1;
	BITFIELD FIE1                           : 1;
	BITFIELD FMODE1                         : 1;
	BITFIELD FIE0                           : 1;
	BITFIELD FMODE0                         : 1;
} _PWM_FCTRL;
#define sPWM_FCTRL       (*(_PWM_FCTRL *) (0x00F021))

typedef struct {
	BITFIELD FPIN3                          : 1;
	BITFIELD FFLAG3                         : 1;
	BITFIELD FPIN2                          : 1;
	BITFIELD FFLAG2                         : 1;
	BITFIELD FPIN1                          : 1;
	BITFIELD FFLAG1                         : 1;
	BITFIELD FPIN0                          : 1;
	BITFIELD FFLAG0                         : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD FTACL3                         : 1;
	BITFIELD DT5                            : 1;
	BITFIELD DT4_FTACK2                     : 1;
	BITFIELD Dt3                            : 1;
	BITFIELD DT2_FTACK1                     : 1;
	BITFIELD DT1                            : 1;
	BITFIELD DT0_FTACK0                     : 1;
} _PWM_FLTACK;
#define sPWM_FLTACK      (*(_PWM_FLTACK *) (0x00F022))

typedef struct {
	BITFIELD PAD_EN                         : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD OUTCTL5                        : 1;
	BITFIELD OUTCTL4                        : 1;
	BITFIELD OUTCTL3                        : 1;
	BITFIELD OUTCTL2                        : 1;
	BITFIELD OUTCTL1                        : 1;
	BITFIELD OUTCTL0                        : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD OUt5                           : 1;
	BITFIELD OUT4                           : 1;
	BITFIELD OUT3                           : 1;
	BITFIELD OUT2                           : 1;
	BITFIELD OUT1                           : 1;
	BITFIELD OUT0                           : 1;
} _PWM_OUT;
#define sPWM_OUT         (*(_PWM_OUT *) (0x00F023))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD CR                             : 15;
} _PWM_CNTR;
#define sPWM_CNTR        (*(_PWM_CNTR *) (0x00F024))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD PWMCM                          : 15;
} _PWM_CMOD;
#define sPWM_CMOD        (*(_PWM_CMOD *) (0x00F025))

typedef struct {
	BITFIELD PMVAL                          : 16;
} _PWM_VAL0;
#define sPWM_VAL0        (*(_PWM_VAL0 *) (0x00F026))

typedef struct {
	BITFIELD PMVAL                          : 16;
} _PWM_VAL1;
#define sPWM_VAL1        (*(_PWM_VAL1 *) (0x00F027))

typedef struct {
	BITFIELD PMVAL                          : 16;
} _PWM_VAL2;
#define sPWM_VAL2        (*(_PWM_VAL2 *) (0x00F028))

typedef struct {
	BITFIELD PMVAL                          : 16;
} _PWM_VAL3;
#define sPWM_VAL3        (*(_PWM_VAL3 *) (0x00F029))

typedef struct {
	BITFIELD PMVAL                          : 16;
} _PWM_VAL4;
#define sPWM_VAL4        (*(_PWM_VAL4 *) (0x00F02A))

typedef struct {
	BITFIELD PMVAL                          : 16;
} _PWM_VAL5;
#define sPWM_VAL5        (*(_PWM_VAL5 *) (0x00F02B))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD PWMDT0                         : 12;
} _PWM_DTIM0;
#define sPWM_DTIM0       (*(_PWM_DTIM0 *) (0x00F02C))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD PWMDT1                         : 12;
} _PWM_DTIM1;
#define sPWM_DTIM1       (*(_PWM_DTIM1 *) (0x00F02D))

typedef struct {
	BITFIELD DISMAP_15_0                    : 16;
} _PWM_DMAP1;
#define sPWM_DMAP1       (*(_PWM_DMAP1 *) (0x00F02E))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DISMAP_23_16                   : 8;
} _PWM_DMAP2;
#define sPWM_DMAP2       (*(_PWM_DMAP2 *) (0x00F02F))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD DBG_EN                         : 1;
	BITFIELD WAIT_EN                        : 1;
	BITFIELD EDG                            : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD TOPNEG45                       : 1;
	BITFIELD TOPNEG23                       : 1;
	BITFIELD TOPNEG01                       : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD BOTNEG45                       : 1;
	BITFIELD BOTNEG23                       : 1;
	BITFIELD BOTNEG01                       : 1;
	BITFIELD INDEP45                        : 1;
	BITFIELD INDEP23                        : 1;
	BITFIELD INDEP01                        : 1;
	BITFIELD WP                             : 1;
} _PWM_CNFG;
#define sPWM_CNFG        (*(_PWM_CNFG *) (0x00F030))

typedef struct {
	BITFIELD ENHA                           : 1;
	BITFIELD nBX                            : 1;
	BITFIELD MSK5                           : 1;
	BITFIELD MSK4                           : 1;
	BITFIELD MSK3                           : 1;
	BITFIELD MSK2                           : 1;
	BITFIELD MSK1                           : 1;
	BITFIELD MSK0                           : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD VLMODE                         : 2;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD SWP45                          : 1;
	BITFIELD SWP23                          : 1;
	BITFIELD SWP01                          : 1;
} _PWM_CCTRL;
#define sPWM_CCTRL       (*(_PWM_CCTRL *) (0x00F031))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD PORT                           : 7;
} _PWM_PORT;
#define sPWM_PORT        (*(_PWM_PORT *) (0x00F032))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD PEC2                           : 1;
	BITFIELD PEC1                           : 1;
	BITFIELD PEC0                           : 1;
	BITFIELD ICC2                           : 1;
	BITFIELD ICC1                           : 1;
	BITFIELD ICC0                           : 1;
} _PWM_ICCTRL;
#define sPWM_ICCTRL      (*(_PWM_ICCTRL *) (0x00F033))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD CINV5                          : 1;
	BITFIELD CINV4                          : 1;
	BITFIELD CINV3                          : 1;
	BITFIELD CINV2                          : 1;
	BITFIELD CINV1                          : 1;
	BITFIELD CINV0                          : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD SRC2                           : 2;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD SRC1                           : 2;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD SRC0                           : 1;
} _PWM_SCTRL;
#define sPWM_SCTRL       (*(_PWM_SCTRL *) (0x00F034))

typedef struct {
	BITFIELD SYNC_OUT_EN                    : 1;
	BITFIELD SYNC_WINDOW                    : 15;
} _PWM_SYNC;
#define sPWM_SYNC        (*(_PWM_SYNC *) (0x00F035))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD FILT0_CNT                      : 3;
	BITFIELD FILT0_PER                      : 8;
} _PWM_FFILT0;
#define sPWM_FFILT0      (*(_PWM_FFILT0 *) (0x00F036))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD FILT1_CNT                      : 3;
	BITFIELD FILT1_PER                      : 8;
} _PWM_FFILT1;
#define sPWM_FFILT1      (*(_PWM_FFILT1 *) (0x00F037))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD FILT2_CNT                      : 3;
	BITFIELD FILT2_PER                      : 8;
} _PWM_FFILT2;
#define sPWM_FFILT2      (*(_PWM_FFILT2 *) (0x00F038))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD FILT3_CNT                      : 3;
	BITFIELD FILT3_PER                      : 8;
} _PWM_FFILT3;
#define sPWM_FFILT3      (*(_PWM_FFILT3 *) (0x00F039))


///////////////////////////////////////////////////////////////////////////////////
// INTC Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD INT                            : 1;
	BITFIELD IPIC                           : 2;
	BITFIELD VAB                            : 7;
	BITFIELD INT_DIS                        : 1;
	BITFIELD ERRF                           : 1;
	BITFIELD ETRE                           : 1;
	BITFIELD TRBUF                          : 1;
	BITFIELD BKPT                           : 1;
	BITFIELD STPCNT                         : 1;
} _INTC_ICSR;
#define sINTC_ICSR       (*(_INTC_ICSR *) (0x00F040))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD VECTOR_BASE_ADDRESS            : 14;
} _INTC_VBA;
#define sINTC_VBA        (*(_INTC_VBA *) (0x00F041))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD USER2                          : 6;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD USER1                          : 6;
} _INTC_IAR0;
#define sINTC_IAR0       (*(_INTC_IAR0 *) (0x00F042))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD USER4                          : 6;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD USER3                          : 6;
} _INTC_IAR1;
#define sINTC_IAR1       (*(_INTC_IAR1 *) (0x00F043))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD USER6                          : 6;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD USER5                          : 6;
} _INTC_IAR2;
#define sINTC_IAR2       (*(_INTC_IAR2 *) (0x00F044))


///////////////////////////////////////////////////////////////////////////////////
// ADC0 Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD COCO                           : 1;
	BITFIELD AIEN                           : 1;
	BITFIELD ADCO                           : 1;
	BITFIELD ADCH                           : 5;
} _ADC0_ADCSC1A;
#define sADC0_ADCSC1A    (*(_ADC0_ADCSC1A *) (0x00F060))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD ADACT                          : 1;
	BITFIELD ADTRG                          : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD ECC                            : 1;
	BITFIELD REFSEL                         : 2;
} _ADC0_ADCSC2;
#define sADC0_ADCSC2     (*(_ADC0_ADCSC2 *) (0x00F061))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD ADLPC                          : 1;
	BITFIELD ADIV                           : 2;
	BITFIELD ADLSMP                         : 1;
	BITFIELD MODE                           : 2;
	BITFIELD ADICLK                         : 2;
} _ADC0_ADCCFG;
#define sADC0_ADCCFG     (*(_ADC0_ADCCFG *) (0x00F066))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD COCO                           : 1;
	BITFIELD AIEN                           : 1;
	BITFIELD ADCO                           : 1;
	BITFIELD ADCH                           : 5;
} _ADC0_ADCSC1B;
#define sADC0_ADCSC1B    (*(_ADC0_ADCSC1B *) (0x00F06A))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD ADR11                          : 1;
	BITFIELD ADR10                          : 1;
	BITFIELD ADR9                           : 1;
	BITFIELD ADR8                           : 1;
	BITFIELD ADR7                           : 1;
	BITFIELD ADR6                           : 1;
	BITFIELD ADR5                           : 1;
	BITFIELD ADR4                           : 1;
	BITFIELD ADR3                           : 1;
	BITFIELD ADR2                           : 1;
	BITFIELD ADR1                           : 1;
	BITFIELD ADR0                           : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _ADC0_ADCRA;
#define sADC0_ADCRA      (*(_ADC0_ADCRA *) (0x00F06B))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD ADR11                          : 1;
	BITFIELD ADR10                          : 1;
	BITFIELD ADR9                           : 1;
	BITFIELD ADR8                           : 1;
	BITFIELD ADR7                           : 1;
	BITFIELD ADR6                           : 1;
	BITFIELD ADR5                           : 1;
	BITFIELD ADR4                           : 1;
	BITFIELD ADR3                           : 1;
	BITFIELD ADR2                           : 1;
	BITFIELD ADR1                           : 1;
	BITFIELD ADR0                           : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _ADC0_ADCRB;
#define sADC0_ADCRB      (*(_ADC0_ADCRB *) (0x00F06C))


///////////////////////////////////////////////////////////////////////////////////
// ADC1 Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD COCO                           : 1;
	BITFIELD AIEN                           : 1;
	BITFIELD ADCO                           : 1;
	BITFIELD ADCH                           : 5;
} _ADC1_ADCSC1A;
#define sADC1_ADCSC1A    (*(_ADC1_ADCSC1A *) (0x00F080))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD ADACT                          : 1;
	BITFIELD ADTRG                          : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD ECC                            : 1;
	BITFIELD REFSEL                         : 2;
} _ADC1_ADCSC2;
#define sADC1_ADCSC2     (*(_ADC1_ADCSC2 *) (0x00F081))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD ADLPC                          : 1;
	BITFIELD ADIV                           : 2;
	BITFIELD ADLSMP                         : 1;
	BITFIELD MODE                           : 2;
	BITFIELD ADICLK                         : 2;
} _ADC1_ADCCFG;
#define sADC1_ADCCFG     (*(_ADC1_ADCCFG *) (0x00F086))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD COCO                           : 1;
	BITFIELD AIEN                           : 1;
	BITFIELD ADCO                           : 1;
	BITFIELD ADCH                           : 5;
} _ADC1_ADCSC1B;
#define sADC1_ADCSC1B    (*(_ADC1_ADCSC1B *) (0x00F08A))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD ADR11                          : 1;
	BITFIELD ADR10                          : 1;
	BITFIELD ADR9                           : 1;
	BITFIELD ADR8                           : 1;
	BITFIELD ADR7                           : 1;
	BITFIELD ADR6                           : 1;
	BITFIELD ADR5                           : 1;
	BITFIELD ADR4                           : 1;
	BITFIELD ADR3                           : 1;
	BITFIELD ADR2                           : 1;
	BITFIELD ADR1                           : 1;
	BITFIELD ADR0                           : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _ADC1_ADCRA;
#define sADC1_ADCRA      (*(_ADC1_ADCRA *) (0x00F08B))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD ADR11                          : 1;
	BITFIELD ADR10                          : 1;
	BITFIELD ADR9                           : 1;
	BITFIELD ADR8                           : 1;
	BITFIELD ADR7                           : 1;
	BITFIELD ADR6                           : 1;
	BITFIELD ADR5                           : 1;
	BITFIELD ADR4                           : 1;
	BITFIELD ADR3                           : 1;
	BITFIELD ADR2                           : 1;
	BITFIELD ADR1                           : 1;
	BITFIELD ADR0                           : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _ADC1_ADCRB;
#define sADC1_ADCRB      (*(_ADC1_ADCRB *) (0x00F08C))


///////////////////////////////////////////////////////////////////////////////////
// PGA0 Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD TM                             : 1;
	BITFIELD GAINSEL                        : 5;
	BITFIELD LP                             : 1;
	BITFIELD EN                             : 1;
} _PGA0_CNTL0;
#define sPGA0_CNTL0      (*(_PGA0_CNTL0 *) (0x00F0A0))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD BP                             : 1;
	BITFIELD CALMODE                        : 2;
	BITFIELD CPD                            : 3;
} _PGA0_CNTL1;
#define sPGA0_CNTL1      (*(_PGA0_CNTL1 *) (0x00F0A1))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD SWTRIG                         : 1;
	BITFIELD NUM_CLK_GS                     : 3;
	BITFIELD ADIV                           : 2;
} _PGA0_CNTL2;
#define sPGA0_CNTL2      (*(_PGA0_CNTL2 *) (0x00F0A2))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RUNNING                        : 1;
	BITFIELD STCOMP                         : 1;
} _PGA0_STS;
#define sPGA0_STS        (*(_PGA0_STS *) (0x00F0A3))


///////////////////////////////////////////////////////////////////////////////////
// PGA1 Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD TM                             : 1;
	BITFIELD GAINSEL                        : 5;
	BITFIELD LP                             : 1;
	BITFIELD EN                             : 1;
} _PGA1_CNTL0;
#define sPGA1_CNTL0      (*(_PGA1_CNTL0 *) (0x00F0C0))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD BP                             : 1;
	BITFIELD CALMODE                        : 2;
	BITFIELD CPD                            : 3;
} _PGA1_CNTL1;
#define sPGA1_CNTL1      (*(_PGA1_CNTL1 *) (0x00F0C1))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD SWTRIG                         : 1;
	BITFIELD NUM_CLK_GS                     : 3;
	BITFIELD ADIV                           : 2;
} _PGA1_CNTL2;
#define sPGA1_CNTL2      (*(_PGA1_CNTL2 *) (0x00F0C2))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RUNNING                        : 1;
	BITFIELD STCOMP                         : 1;
} _PGA1_STS;
#define sPGA1_STS        (*(_PGA1_STS *) (0x00F0C3))


///////////////////////////////////////////////////////////////////////////////////
// SCI Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD SBR                            : 13;
	BITFIELD FRAC_SBR                       : 3;
} _SCI_RATE;
#define sSCI_RATE        (*(_SCI_RATE *) (0x00F0E0))

typedef struct {
	BITFIELD LOOP                           : 1;
	BITFIELD SWAI                           : 1;
	BITFIELD RSRC                           : 1;
	BITFIELD M                              : 1;
	BITFIELD WAKE                           : 1;
	BITFIELD POL                            : 1;
	BITFIELD PE                             : 1;
	BITFIELD PT                             : 1;
	BITFIELD TEIE                           : 1;
	BITFIELD TIIE                           : 1;
	BITFIELD RFIE                           : 1;
	BITFIELD REIE                           : 1;
	BITFIELD TE                             : 1;
	BITFIELD RE                             : 1;
	BITFIELD RWU                            : 1;
	BITFIELD SBK                            : 1;
} _SCI_CTRL1;
#define sSCI_CTRL1       (*(_SCI_CTRL1 *) (0x00F0E1))

typedef struct {
	BITFIELD TFCNT                          : 3;
	BITFIELD TFWM                           : 2;
	BITFIELD RFCNT                          : 3;
	BITFIELD RFWM                           : 2;
	BITFIELD FIFO_EN                        : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD LIN_MODE                       : 1;
	BITFIELD RIIE                           : 1;
	BITFIELD TDE                            : 1;
	BITFIELD RDE                            : 1;
} _SCI_CTRL2;
#define sSCI_CTRL2       (*(_SCI_CTRL2 *) (0x00F0E2))

typedef struct {
	BITFIELD TDRE                           : 1;
	BITFIELD TIDLE                          : 1;
	BITFIELD RDRF                           : 1;
	BITFIELD RIDLE                          : 1;
	BITFIELD OR                             : 1;
	BITFIELD NF                             : 1;
	BITFIELD FE                             : 1;
	BITFIELD PF                             : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD LSE                            : 1;
	BITFIELD TDMA                           : 1;
	BITFIELD RDMA                           : 1;
	BITFIELD RAF                            : 1;
} _SCI_STAT;
#define sSCI_STAT        (*(_SCI_STAT *) (0x00F0E3))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD Receive_Transmit_Data          : 10;
} _SCI_DATA;
#define sSCI_DATA        (*(_SCI_DATA *) (0x00F0E4))


///////////////////////////////////////////////////////////////////////////////////
// SPI Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD SPR                            : 3;
	BITFIELD DSO                            : 1;
	BITFIELD EERIE                          : 1;
	BITFIELD MODFEN                         : 1;
	BITFIELD SPRIE                          : 1;
	BITFIELD SPMSTR                         : 1;
	BITFIELD CPOL                           : 1;
	BITFIELD CPHA                           : 1;
	BITFIELD SPE                            : 1;
	BITFIELD SPTIE                          : 1;
	BITFIELD SPRF                           : 1;
	BITFIELD OVRF                           : 1;
	BITFIELD MODF                           : 1;
	BITFIELD SPTE                           : 1;
} _SPI_SCTRL;
#define sSPI_SCTRL       (*(_SPI_SCTRL *) (0x00F100))

typedef struct {
	BITFIELD WOM                            : 1;
	BITFIELD TDMAEN                         : 1;
	BITFIELD RDMAEN                         : 1;
	BITFIELD BD2X                           : 1;
	BITFIELD SSB_IN                         : 1;
	BITFIELD SSB_DATA                       : 1;
	BITFIELD SSB_ODM                        : 1;
	BITFIELD SSB_AUTO                       : 1;
	BITFIELD SSB_DDR                        : 1;
	BITFIELD SSB_STRB                       : 1;
	BITFIELD SSB_OVER                       : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD DS                             : 4;
} _SPI_DSCTRL;
#define sSPI_DSCTRL      (*(_SPI_DSCTRL *) (0x00F101))

typedef struct {
	BITFIELD R15                            : 1;
	BITFIELD R14                            : 1;
	BITFIELD R13                            : 1;
	BITFIELD R12                            : 1;
	BITFIELD R11                            : 1;
	BITFIELD R10                            : 1;
	BITFIELD R9                             : 1;
	BITFIELD R8                             : 1;
	BITFIELD R7                             : 1;
	BITFIELD R6                             : 1;
	BITFIELD R5                             : 1;
	BITFIELD R4                             : 1;
	BITFIELD R3                             : 1;
	BITFIELD R2                             : 1;
	BITFIELD R1                             : 1;
	BITFIELD R0                             : 1;
} _SPI_DRCV;
#define sSPI_DRCV        (*(_SPI_DRCV *) (0x00F102))

typedef struct {
	BITFIELD T15                            : 1;
	BITFIELD T14                            : 1;
	BITFIELD T13                            : 1;
	BITFIELD T12                            : 1;
	BITFIELD T11                            : 1;
	BITFIELD T10                            : 1;
	BITFIELD T9                             : 1;
	BITFIELD T8                             : 1;
	BITFIELD T7                             : 1;
	BITFIELD T6                             : 1;
	BITFIELD T5                             : 1;
	BITFIELD T4                             : 1;
	BITFIELD T3                             : 1;
	BITFIELD T2                             : 1;
	BITFIELD T1                             : 1;
	BITFIELD T0                             : 1;
} _SPI_DXMIT;
#define sSPI_DXMIT       (*(_SPI_DXMIT *) (0x00F103))


///////////////////////////////////////////////////////////////////////////////////
// I2C Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD AD7                            : 1;
	BITFIELD AD6                            : 1;
	BITFIELD AD5                            : 1;
	BITFIELD AD4                            : 1;
	BITFIELD AD3                            : 1;
	BITFIELD AD2                            : 1;
	BITFIELD AD1                            : 1;
	BITFIELD RESERVED0_0                    : 1;
} _I2C_ADDR;
#define sI2C_ADDR        (*(_I2C_ADDR *) (0x00F120))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD MULT                           : 2;
	BITFIELD ICR                            : 6;
} _I2C_FREQDIV;
#define sI2C_FREQDIV     (*(_I2C_FREQDIV *) (0x00F121))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IICEN                          : 1;
	BITFIELD IICIE                          : 1;
	BITFIELD MST                            : 1;
	BITFIELD TX                             : 1;
	BITFIELD TXAK                           : 1;
	BITFIELD RSTA                           : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _I2C_CR1;
#define sI2C_CR1         (*(_I2C_CR1 *) (0x00F122))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD TCF                            : 1;
	BITFIELD IAAS                           : 1;
	BITFIELD BUSY                           : 1;
	BITFIELD ARBL                           : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD SRW                            : 1;
	BITFIELD IICIF                          : 1;
	BITFIELD RXAK                           : 1;
} _I2C_SR;
#define sI2C_SR          (*(_I2C_SR *) (0x00F123))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DATA                           : 8;
} _I2C_DATA;
#define sI2C_DATA        (*(_I2C_DATA *) (0x00F124))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD GCAEN                          : 1;
	BITFIELD ADEXT                          : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD AD10                           : 1;
	BITFIELD AD9                            : 1;
	BITFIELD AD8                            : 1;
} _I2C_CR2;
#define sI2C_CR2         (*(_I2C_CR2 *) (0x00F125))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD FACK                           : 1;
	BITFIELD ALERTEN                        : 1;
	BITFIELD SIICAEN                        : 1;
	BITFIELD TCKSEL                         : 1;
	BITFIELD SLTF                           : 1;
	BITFIELD SHTF                           : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _I2C_SMB_CSR;
#define sI2C_SMB_CSR     (*(_I2C_SMB_CSR *) (0x00F126))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD SAD7                           : 1;
	BITFIELD SAD6                           : 1;
	BITFIELD SAD5                           : 1;
	BITFIELD SAD4                           : 1;
	BITFIELD SAD3                           : 1;
	BITFIELD SAD2                           : 1;
	BITFIELD SAD1                           : 1;
	BITFIELD RESERVED0_0                    : 1;
} _I2C_ADDR2;
#define sI2C_ADDR2       (*(_I2C_ADDR2 *) (0x00F127))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD SSLT7                          : 1;
	BITFIELD SSLT6                          : 1;
	BITFIELD SSLT5                          : 1;
	BITFIELD SSLT4                          : 1;
	BITFIELD SSLT3                          : 1;
	BITFIELD SSLT2                          : 1;
	BITFIELD SSLT1                          : 1;
	BITFIELD SSLT0                          : 1;
} _I2C_SLT1;
#define sI2C_SLT1        (*(_I2C_SLT1 *) (0x00F128))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD SSLT15                         : 1;
	BITFIELD SSLT14                         : 1;
	BITFIELD SSLT13                         : 1;
	BITFIELD SSLT12                         : 1;
	BITFIELD SSLT11                         : 1;
	BITFIELD SSLT10                         : 1;
	BITFIELD SSLT9                          : 1;
	BITFIELD SSLT8                          : 1;
} _I2C_SLT2;
#define sI2C_SLT2        (*(_I2C_SLT2 *) (0x00F129))


///////////////////////////////////////////////////////////////////////////////////
// COP Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD PSS                            : 2;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD CLKSEL                         : 2;
	BITFIELD CLOREN                         : 1;
	BITFIELD CSEN                           : 1;
	BITFIELD CWEN                           : 1;
	BITFIELD CEN                            : 1;
	BITFIELD CWP                            : 1;
} _COP_CTRL;
#define sCOP_CTRL        (*(_COP_CTRL *) (0x00F140))

typedef struct {
	BITFIELD TIMEOUT                        : 16;
} _COP_TOUT;
#define sCOP_TOUT        (*(_COP_TOUT *) (0x00F141))

typedef struct {
	BITFIELD COUNT_SERVICE                  : 16;
} _COP_CNTR;
#define sCOP_CNTR        (*(_COP_CNTR *) (0x00F142))


///////////////////////////////////////////////////////////////////////////////////
// OCCS Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD PLLIE1                         : 2;
	BITFIELD PLLIE0                         : 2;
	BITFIELD LOCIE                          : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD LCKON                          : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD PLLPD                          : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD PRECS                          : 1;
	BITFIELD ZSRC                           : 2;
} _OCCS_CTRL;
#define sOCCS_CTRL       (*(_OCCS_CTRL *) (0x00F160))

typedef struct {
	BITFIELD LORTP                          : 4;
	BITFIELD COD                            : 4;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _OCCS_DIVBY;
#define sOCCS_DIVBY      (*(_OCCS_DIVBY *) (0x00F161))

typedef struct {
	BITFIELD LOLI1                          : 1;
	BITFIELD LOLI0                          : 1;
	BITFIELD LOCI                           : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD LCK1                           : 1;
	BITFIELD LCK0                           : 1;
	BITFIELD PLLPDN                         : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD COSC_RDY                       : 1;
	BITFIELD ZSRCS                          : 2;
} _OCCS_STAT;
#define sOCCS_STAT       (*(_OCCS_STAT *) (0x00F162))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD TPLLREF                        : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD TFDBK                          : 1;
	BITFIELD TFREF                          : 1;
	BITFIELD FLOCI                          : 1;
	BITFIELD FLOLI1                         : 1;
	BITFIELD FLOLI0                         : 1;
	BITFIELD TM                             : 1;
} _OCCS_TESTR;
#define sOCCS_TESTR      (*(_OCCS_TESTR *) (0x00F163))

typedef struct {
	BITFIELD ROPD                           : 1;
	BITFIELD ROSB                           : 1;
	BITFIELD COHL                           : 1;
	BITFIELD CLK_MODE                       : 1;
	BITFIELD RANGE                          : 1;
	BITFIELD EXT_SEL                        : 1;
	BITFIELD TRIM                           : 10;
} _OCCS_OCTRL;
#define sOCCS_OCTRL      (*(_OCCS_OCTRL *) (0x00F164))

typedef struct {
	BITFIELD CHK_ENA                        : 1;
	BITFIELD REFERENCE_CNT                  : 15;
} _OCCS_CLKCHKR;
#define sOCCS_CLKCHKR    (*(_OCCS_CLKCHKR *) (0x00F165))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD TARGET_CNT                     : 7;
} _OCCS_CLKCHKT;
#define sOCCS_CLKCHKT    (*(_OCCS_CLKCHKT *) (0x00F166))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD FRQEP                          : 2;
	BITFIELD OSCEP                          : 2;
	BITFIELD PLLEP                          : 2;
} _OCCS_PROT;
#define sOCCS_PROT       (*(_OCCS_PROT *) (0x00F167))


///////////////////////////////////////////////////////////////////////////////////
// GPIOA Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD PUR                            : 8;
} _GPIOA_PUR;
#define sGPIOA_PUR       (*(_GPIOA_PUR *) (0x00F180))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DR                             : 8;
} _GPIOA_DR;
#define sGPIOA_DR        (*(_GPIOA_DR *) (0x00F181))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DDR                            : 8;
} _GPIOA_DDR;
#define sGPIOA_DDR       (*(_GPIOA_DDR *) (0x00F182))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD PER                            : 8;
} _GPIOA_PER;
#define sGPIOA_PER       (*(_GPIOA_PER *) (0x00F183))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IENR                           : 8;
} _GPIOA_IENR;
#define sGPIOA_IENR      (*(_GPIOA_IENR *) (0x00F185))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IPOLR                          : 8;
} _GPIOA_IPOLR;
#define sGPIOA_IPOLR     (*(_GPIOA_IPOLR *) (0x00F186))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IPR                            : 8;
} _GPIOA_IPR;
#define sGPIOA_IPR       (*(_GPIOA_IPR *) (0x00F187))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IESR                           : 8;
} _GPIOA_IESR;
#define sGPIOA_IESR      (*(_GPIOA_IESR *) (0x00F188))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RAWDATA                        : 8;
} _GPIOA_RAWDATA;
#define sGPIOA_RAWDATA   (*(_GPIOA_RAWDATA *) (0x00F18A))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DRIVE                          : 8;
} _GPIOA_DRIVE;
#define sGPIOA_DRIVE     (*(_GPIOA_DRIVE *) (0x00F18B))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IFE                            : 8;
} _GPIOA_IFE;
#define sGPIOA_IFE       (*(_GPIOA_IFE *) (0x00F18C))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD SLEW                           : 8;
} _GPIOA_SLEW;
#define sGPIOA_SLEW      (*(_GPIOA_SLEW *) (0x00F18D))


///////////////////////////////////////////////////////////////////////////////////
// GPIOB Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD PUR                            : 8;
} _GPIOB_PUR;
#define sGPIOB_PUR       (*(_GPIOB_PUR *) (0x00F1A0))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DR                             : 8;
} _GPIOB_DR;
#define sGPIOB_DR        (*(_GPIOB_DR *) (0x00F1A1))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DDR                            : 8;
} _GPIOB_DDR;
#define sGPIOB_DDR       (*(_GPIOB_DDR *) (0x00F1A2))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD PER                            : 8;
} _GPIOB_PER;
#define sGPIOB_PER       (*(_GPIOB_PER *) (0x00F1A3))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IENR                           : 8;
} _GPIOB_IENR;
#define sGPIOB_IENR      (*(_GPIOB_IENR *) (0x00F1A5))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IPOLR                          : 8;
} _GPIOB_IPOLR;
#define sGPIOB_IPOLR     (*(_GPIOB_IPOLR *) (0x00F1A6))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IPR                            : 8;
} _GPIOB_IPR;
#define sGPIOB_IPR       (*(_GPIOB_IPR *) (0x00F1A7))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IESR                           : 8;
} _GPIOB_IESR;
#define sGPIOB_IESR      (*(_GPIOB_IESR *) (0x00F1A8))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RAWDATA                        : 8;
} _GPIOB_RAWDATA;
#define sGPIOB_RAWDATA   (*(_GPIOB_RAWDATA *) (0x00F1AA))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DRIVE                          : 8;
} _GPIOB_DRIVE;
#define sGPIOB_DRIVE     (*(_GPIOB_DRIVE *) (0x00F1AB))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IFE                            : 8;
} _GPIOB_IFE;
#define sGPIOB_IFE       (*(_GPIOB_IFE *) (0x00F1AC))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD SLEW                           : 8;
} _GPIOB_SLEW;
#define sGPIOB_SLEW      (*(_GPIOB_SLEW *) (0x00F1AD))


///////////////////////////////////////////////////////////////////////////////////
// GPIOC Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD PUR                            : 8;
} _GPIOC_PUR;
#define sGPIOC_PUR       (*(_GPIOC_PUR *) (0x00F1C0))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DR                             : 8;
} _GPIOC_DR;
#define sGPIOC_DR        (*(_GPIOC_DR *) (0x00F1C1))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DDR                            : 8;
} _GPIOC_DDR;
#define sGPIOC_DDR       (*(_GPIOC_DDR *) (0x00F1C2))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD PER                            : 8;
} _GPIOC_PER;
#define sGPIOC_PER       (*(_GPIOC_PER *) (0x00F1C3))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IENR                           : 8;
} _GPIOC_IENR;
#define sGPIOC_IENR      (*(_GPIOC_IENR *) (0x00F1C5))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IPOLR                          : 8;
} _GPIOC_IPOLR;
#define sGPIOC_IPOLR     (*(_GPIOC_IPOLR *) (0x00F1C6))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IPR                            : 8;
} _GPIOC_IPR;
#define sGPIOC_IPR       (*(_GPIOC_IPR *) (0x00F1C7))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IESR                           : 8;
} _GPIOC_IESR;
#define sGPIOC_IESR      (*(_GPIOC_IESR *) (0x00F1C8))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RAWDATA                        : 8;
} _GPIOC_RAWDATA;
#define sGPIOC_RAWDATA   (*(_GPIOC_RAWDATA *) (0x00F1CA))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DRIVE                          : 8;
} _GPIOC_DRIVE;
#define sGPIOC_DRIVE     (*(_GPIOC_DRIVE *) (0x00F1CB))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IFE                            : 8;
} _GPIOC_IFE;
#define sGPIOC_IFE       (*(_GPIOC_IFE *) (0x00F1CC))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD SLEW                           : 8;
} _GPIOC_SLEW;
#define sGPIOC_SLEW      (*(_GPIOC_SLEW *) (0x00F1CD))


///////////////////////////////////////////////////////////////////////////////////
// GPIOD Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD PUR                            : 4;
} _GPIOD_PUR;
#define sGPIOD_PUR       (*(_GPIOD_PUR *) (0x00F1E0))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD DR                             : 4;
} _GPIOD_DR;
#define sGPIOD_DR        (*(_GPIOD_DR *) (0x00F1E1))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD DDR                            : 4;
} _GPIOD_DDR;
#define sGPIOD_DDR       (*(_GPIOD_DDR *) (0x00F1E2))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD PER                            : 4;
} _GPIOD_PER;
#define sGPIOD_PER       (*(_GPIOD_PER *) (0x00F1E3))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD IENR                           : 4;
} _GPIOD_IENR;
#define sGPIOD_IENR      (*(_GPIOD_IENR *) (0x00F1E5))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD IPOLR                          : 4;
} _GPIOD_IPOLR;
#define sGPIOD_IPOLR     (*(_GPIOD_IPOLR *) (0x00F1E6))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD IPR                            : 4;
} _GPIOD_IPR;
#define sGPIOD_IPR       (*(_GPIOD_IPR *) (0x00F1E7))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD IESR                           : 4;
} _GPIOD_IESR;
#define sGPIOD_IESR      (*(_GPIOD_IESR *) (0x00F1E8))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RAWDATA                        : 4;
} _GPIOD_RAWDATA;
#define sGPIOD_RAWDATA   (*(_GPIOD_RAWDATA *) (0x00F1EA))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD DRIVE                          : 4;
} _GPIOD_DRIVE;
#define sGPIOD_DRIVE     (*(_GPIOD_DRIVE *) (0x00F1EB))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD IFE                            : 4;
} _GPIOD_IFE;
#define sGPIOD_IFE       (*(_GPIOD_IFE *) (0x00F1EC))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD SLEW                           : 4;
} _GPIOD_SLEW;
#define sGPIOD_SLEW      (*(_GPIOD_SLEW *) (0x00F1ED))


///////////////////////////////////////////////////////////////////////////////////
// GPIOE Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD PUR                            : 8;
} _GPIOE_PUR;
#define sGPIOE_PUR       (*(_GPIOE_PUR *) (0x00F200))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DR                             : 8;
} _GPIOE_DR;
#define sGPIOE_DR        (*(_GPIOE_DR *) (0x00F201))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DDR                            : 8;
} _GPIOE_DDR;
#define sGPIOE_DDR       (*(_GPIOE_DDR *) (0x00F202))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD PER                            : 8;
} _GPIOE_PER;
#define sGPIOE_PER       (*(_GPIOE_PER *) (0x00F203))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IENR                           : 8;
} _GPIOE_IENR;
#define sGPIOE_IENR      (*(_GPIOE_IENR *) (0x00F205))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IPOLR                          : 8;
} _GPIOE_IPOLR;
#define sGPIOE_IPOLR     (*(_GPIOE_IPOLR *) (0x00F206))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IPR                            : 8;
} _GPIOE_IPR;
#define sGPIOE_IPR       (*(_GPIOE_IPR *) (0x00F207))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IESR                           : 8;
} _GPIOE_IESR;
#define sGPIOE_IESR      (*(_GPIOE_IESR *) (0x00F208))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RAWDATA                        : 8;
} _GPIOE_RAWDATA;
#define sGPIOE_RAWDATA   (*(_GPIOE_RAWDATA *) (0x00F20A))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DRIVE                          : 8;
} _GPIOE_DRIVE;
#define sGPIOE_DRIVE     (*(_GPIOE_DRIVE *) (0x00F20B))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD IFE                            : 8;
} _GPIOE_IFE;
#define sGPIOE_IFE       (*(_GPIOE_IFE *) (0x00F20C))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD SLEW                           : 8;
} _GPIOE_SLEW;
#define sGPIOE_SLEW      (*(_GPIOE_SLEW *) (0x00F20D))


///////////////////////////////////////////////////////////////////////////////////
// GPIOF Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD PUR                            : 4;
} _GPIOF_PUR;
#define sGPIOF_PUR       (*(_GPIOF_PUR *) (0x00F220))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD DR                             : 4;
} _GPIOF_DR;
#define sGPIOF_DR        (*(_GPIOF_DR *) (0x00F221))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD DDR                            : 4;
} _GPIOF_DDR;
#define sGPIOF_DDR       (*(_GPIOF_DDR *) (0x00F222))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD PER                            : 4;
} _GPIOF_PER;
#define sGPIOF_PER       (*(_GPIOF_PER *) (0x00F223))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD IENR                           : 4;
} _GPIOF_IENR;
#define sGPIOF_IENR      (*(_GPIOF_IENR *) (0x00F225))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD IPOLR                          : 4;
} _GPIOF_IPOLR;
#define sGPIOF_IPOLR     (*(_GPIOF_IPOLR *) (0x00F226))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD IPR                            : 4;
} _GPIOF_IPR;
#define sGPIOF_IPR       (*(_GPIOF_IPR *) (0x00F227))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD IESR                           : 4;
} _GPIOF_IESR;
#define sGPIOF_IESR      (*(_GPIOF_IESR *) (0x00F228))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RAWDATA                        : 4;
} _GPIOF_RAWDATA;
#define sGPIOF_RAWDATA   (*(_GPIOF_RAWDATA *) (0x00F22A))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD DRIVE                          : 4;
} _GPIOF_DRIVE;
#define sGPIOF_DRIVE     (*(_GPIOF_DRIVE *) (0x00F22B))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD IFE                            : 4;
} _GPIOF_IFE;
#define sGPIOF_IFE       (*(_GPIOF_IFE *) (0x00F22C))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD SLEW                           : 4;
} _GPIOF_SLEW;
#define sGPIOF_SLEW      (*(_GPIOF_SLEW *) (0x00F22D))


///////////////////////////////////////////////////////////////////////////////////
// SIM Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD Once_Ebl                       : 1;
	BITFIELD SW_Rst                         : 1;
	BITFIELD STOP_disable                   : 2;
	BITFIELD WAIT_disable                   : 2;
} _SIM_CTRL;
#define sSIM_CTRL        (*(_SIM_CTRL *) (0x00F240))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD SWR                            : 1;
	BITFIELD COP_CPU                        : 1;
	BITFIELD COP_LOR                        : 1;
	BITFIELD EXTR                           : 1;
	BITFIELD LVDR                           : 1;
	BITFIELD PPD                            : 1;
	BITFIELD POR                            : 1;
} _SIM_RSTAT;
#define sSIM_RSTAT       (*(_SIM_RSTAT *) (0x00F241))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED1_8                    : 1;
	BITFIELD RESERVED1_7                    : 1;
	BITFIELD RESERVED1_6                    : 1;
	BITFIELD RESERVED1_5                    : 1;
	BITFIELD RESERVED1_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED1_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _SIM_MSHID;
#define sSIM_MSHID       (*(_SIM_MSHID *) (0x00F242))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED1_14                   : 1;
	BITFIELD RESERVED1_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED1_4                    : 1;
	BITFIELD RESERVED1_3                    : 1;
	BITFIELD RESERVED1_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED1_0                    : 1;
} _SIM_LSHID;
#define sSIM_LSHID       (*(_SIM_LSHID *) (0x00F243))

typedef struct {
	BITFIELD TRS                            : 9;
	BITFIELD Test_INT                       : 1;
	BITFIELD Test_STOP                      : 1;
	BITFIELD Test_WAIT                      : 1;
	BITFIELD Test_CLKO                      : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD PG_Obs                         : 1;
	BITFIELD CLO_Obs                        : 1;
} _SIM_TEST;
#define sSIM_TEST        (*(_SIM_TEST *) (0x00F244))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD CLKDIS1                        : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD CLKOSEL1                       : 3;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD CLKDIS0                        : 1;
	BITFIELD CLKOSEL0                       : 5;
} _SIM_CLKOUT;
#define sSIM_CLKOUT      (*(_SIM_CLKOUT *) (0x00F245))

typedef struct {
	BITFIELD TMR_CR                         : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD PWM_CR                         : 1;
	BITFIELD SCI_CR                         : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _SIM_PCR;
#define sSIM_PCR         (*(_SIM_PCR *) (0x00F246))

typedef struct {
	BITFIELD CMP2                           : 1;
	BITFIELD CMP1                           : 1;
	BITFIELD CMP0                           : 1;
	BITFIELD ADC1                           : 1;
	BITFIELD ADC0                           : 1;
	BITFIELD PGA1                           : 1;
	BITFIELD PGA0                           : 1;
	BITFIELD I2C                            : 1;
	BITFIELD SCI                            : 1;
	BITFIELD SPI                            : 1;
	BITFIELD PWM                            : 1;
	BITFIELD COP                            : 1;
	BITFIELD PDB                            : 1;
	BITFIELD PIT                            : 1;
	BITFIELD TA1                            : 1;
	BITFIELD TA0                            : 1;
} _SIM_PCE;
#define sSIM_PCE         (*(_SIM_PCE *) (0x00F247))

typedef struct {
	BITFIELD CMP2                           : 1;
	BITFIELD CMP1                           : 1;
	BITFIELD CMP0                           : 1;
	BITFIELD ADC1                           : 1;
	BITFIELD ADC0                           : 1;
	BITFIELD PGA1                           : 1;
	BITFIELD PGA0                           : 1;
	BITFIELD I2C                            : 1;
	BITFIELD SCI                            : 1;
	BITFIELD SPI                            : 1;
	BITFIELD PWM                            : 1;
	BITFIELD COP                            : 1;
	BITFIELD PDB                            : 1;
	BITFIELD PIT                            : 1;
	BITFIELD TA1                            : 1;
	BITFIELD TA0                            : 1;
} _SIM_SDR;
#define sSIM_SDR         (*(_SIM_SDR *) (0x00F248))

typedef struct {
	BITFIELD ADDR_15_6                      : 10;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _SIM_ISAL;
#define sSIM_ISAL        (*(_SIM_ISAL *) (0x00F249))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD PCEP                           : 2;
	BITFIELD GIPSP                          : 2;
} _SIM_PROT;
#define sSIM_PROT        (*(_SIM_PROT *) (0x00F24A))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD GPS_A6                         : 3;
	BITFIELD GPS_A5                         : 2;
	BITFIELD GPS_A4                         : 2;
	BITFIELD GPS_A3                         : 2;
} _SIM_GPSA;
#define sSIM_GPSA        (*(_SIM_GPSA *) (0x00F24B))

typedef struct {
	BITFIELD GPS_B5                         : 2;
	BITFIELD GPS_B4                         : 3;
	BITFIELD GPS_B3                         : 3;
	BITFIELD GPS_B2                         : 2;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD GPS_B1                         : 2;
	BITFIELD GPS_B0                         : 3;
} _SIM_GPSB0;
#define sSIM_GPSB0       (*(_SIM_GPSB0 *) (0x00F24C))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD GPS_B7                         : 2;
	BITFIELD GPS_B6                         : 2;
} _SIM_GPSB1;
#define sSIM_GPSB1       (*(_SIM_GPSB1 *) (0x00F24D))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD GPS_C6                         : 1;
	BITFIELD GPS_C0                         : 1;
} _SIM_GPSC;
#define sSIM_GPSC        (*(_SIM_GPSC *) (0x00F24E))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD GPS_D3                         : 2;
	BITFIELD GPS_D2                         : 2;
	BITFIELD GPS_D1                         : 2;
	BITFIELD GPS_D0                         : 3;
} _SIM_GPSD;
#define sSIM_GPSD        (*(_SIM_GPSD *) (0x00F24F))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD IPS_FAULT3                     : 1;
	BITFIELD IPS_FAULT2                     : 1;
	BITFIELD IPS_FAULT1                     : 1;
	BITFIELD IPS_PSRC2                      : 3;
	BITFIELD IPS_PSRC1                      : 3;
	BITFIELD IPS_PSRC0                      : 3;
} _SIM_IPS0;
#define sSIM_IPS0        (*(_SIM_IPS0 *) (0x00F250))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD IPS_C2_WS                      : 3;
	BITFIELD IPS_C1_WS                      : 3;
	BITFIELD IPS_C0_WS                      : 3;
	BITFIELD IPS_T1                         : 3;
	BITFIELD IPS_T0                         : 3;
} _SIM_IPS1;
#define sSIM_IPS1        (*(_SIM_IPS1 *) (0x00F251))


///////////////////////////////////////////////////////////////////////////////////
// PMC Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD OORF                           : 1;
	BITFIELD LVDF                           : 1;
	BITFIELD PPDF                           : 1;
	BITFIELD PORF                           : 1;
	BITFIELD OORIE                          : 1;
	BITFIELD LVDIE                          : 1;
	BITFIELD LVDRE                          : 1;
	BITFIELD PPDE                           : 1;
	BITFIELD LPR                            : 1;
	BITFIELD LPRS                           : 1;
	BITFIELD LPWUI                          : 1;
	BITFIELD BGBE                           : 1;
	BITFIELD LVDE                           : 1;
	BITFIELD LVLS                           : 1;
	BITFIELD PROT                           : 2;
} _PMC_SCR;
#define sPMC_SCR         (*(_PMC_SCR *) (0x00F260))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD LPO_EN                         : 1;
	BITFIELD LPO_TRIM                       : 3;
	BITFIELD TRIM                           : 5;
} _PMC_CR2;
#define sPMC_CR2         (*(_PMC_CR2 *) (0x00F261))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD LVDS                           : 1;
	BITFIELD LVWS                           : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD VRP                            : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD PMCTE                          : 1;
	BITFIELD LVDFRC                         : 1;
	BITFIELD RESERVED0_0                    : 1;
} _PMC_TESTSC;
#define sPMC_TESTSC      (*(_PMC_TESTSC *) (0x00F262))


///////////////////////////////////////////////////////////////////////////////////
// CMP0 Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD FILTER_CNT                     : 3;
	BITFIELD PMC                            : 2;
	BITFIELD MMC                            : 2;
} _CMP0_CR0;
#define sCMP0_CR0        (*(_CMP0_CR0 *) (0x00F280))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD SE                             : 1;
	BITFIELD WE                             : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD PMODE                          : 1;
	BITFIELD INV                            : 1;
	BITFIELD COS                            : 1;
	BITFIELD OPE                            : 1;
	BITFIELD EN                             : 1;
} _CMP0_CR1;
#define sCMP0_CR1        (*(_CMP0_CR1 *) (0x00F281))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD FILT_PER                       : 8;
} _CMP0_FPR;
#define sCMP0_FPR        (*(_CMP0_FPR *) (0x00F282))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD IER                            : 1;
	BITFIELD IEF                            : 1;
	BITFIELD CFR                            : 1;
	BITFIELD CFF                            : 1;
	BITFIELD COUT                           : 1;
} _CMP0_SCR;
#define sCMP0_SCR        (*(_CMP0_SCR *) (0x00F283))


///////////////////////////////////////////////////////////////////////////////////
// CMP1 Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD FILTER_CNT                     : 3;
	BITFIELD PMC                            : 2;
	BITFIELD MMC                            : 2;
} _CMP1_CR0;
#define sCMP1_CR0        (*(_CMP1_CR0 *) (0x00F2A0))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD SE                             : 1;
	BITFIELD WE                             : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD PMODE                          : 1;
	BITFIELD INV                            : 1;
	BITFIELD COS                            : 1;
	BITFIELD OPE                            : 1;
	BITFIELD EN                             : 1;
} _CMP1_CR1;
#define sCMP1_CR1        (*(_CMP1_CR1 *) (0x00F2A1))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD FILT_PER                       : 8;
} _CMP1_FPR;
#define sCMP1_FPR        (*(_CMP1_FPR *) (0x00F2A2))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD IER                            : 1;
	BITFIELD IEF                            : 1;
	BITFIELD CFR                            : 1;
	BITFIELD CFF                            : 1;
	BITFIELD COUT                           : 1;
} _CMP1_SCR;
#define sCMP1_SCR        (*(_CMP1_SCR *) (0x00F2A3))


///////////////////////////////////////////////////////////////////////////////////
// CMP2 Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD FILTER_CNT                     : 3;
	BITFIELD PMC                            : 2;
	BITFIELD MMC                            : 2;
} _CMP2_CR0;
#define sCMP2_CR0        (*(_CMP2_CR0 *) (0x00F2C0))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD SE                             : 1;
	BITFIELD WE                             : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD PMODE                          : 1;
	BITFIELD INV                            : 1;
	BITFIELD COS                            : 1;
	BITFIELD OPE                            : 1;
	BITFIELD EN                             : 1;
} _CMP2_CR1;
#define sCMP2_CR1        (*(_CMP2_CR1 *) (0x00F2C1))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD FILT_PER                       : 8;
} _CMP2_FPR;
#define sCMP2_FPR        (*(_CMP2_FPR *) (0x00F2C2))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD IER                            : 1;
	BITFIELD IEF                            : 1;
	BITFIELD CFR                            : 1;
	BITFIELD CFF                            : 1;
	BITFIELD COUT                           : 1;
} _CMP2_SCR;
#define sCMP2_SCR        (*(_CMP2_SCR *) (0x00F2C3))


///////////////////////////////////////////////////////////////////////////////////
// PIT Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD PRESCALER                      : 4;
	BITFIELD PRF                            : 1;
	BITFIELD PRIE                           : 1;
	BITFIELD CNT_EN                         : 1;
} _PIT_CTRL;
#define sPIT_CTRL        (*(_PIT_CTRL *) (0x00F2E0))

typedef struct {
	BITFIELD MODULO_VALUE                   : 16;
} _PIT_MOD;
#define sPIT_MOD         (*(_PIT_MOD *) (0x00F2E1))

typedef struct {
	BITFIELD COUNTER_VALUE                  : 16;
} _PIT_CNTR;
#define sPIT_CNTR        (*(_PIT_CNTR *) (0x00F2E2))


///////////////////////////////////////////////////////////////////////////////////
// PDB Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD PRESCALAR                      : 3;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD AOS                            : 2;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD BOS                            : 2;
	BITFIELD CONT                           : 1;
	BITFIELD SWTRIG                         : 1;
	BITFIELD TRIGSEL                        : 3;
	BITFIELD ENA                            : 1;
	BITFIELD ENB                            : 1;
} _PDB_SCR;
#define sPDB_SCR         (*(_PDB_SCR *) (0x00F300))

typedef struct {
	BITFIELD DELAYA                         : 16;
} _PDB_DELAYA;
#define sPDB_DELAYA      (*(_PDB_DELAYA *) (0x00F301))

typedef struct {
	BITFIELD DELAYB                         : 16;
} _PDB_DELAYB;
#define sPDB_DELAYB      (*(_PDB_DELAYB *) (0x00F302))

typedef struct {
	BITFIELD MOD                            : 16;
} _PDB_MOD;
#define sPDB_MOD         (*(_PDB_MOD *) (0x00F303))

typedef struct {
	BITFIELD COUNT                          : 16;
} _PDB_COUNT;
#define sPDB_COUNT       (*(_PDB_COUNT *) (0x00F304))


///////////////////////////////////////////////////////////////////////////////////
// RTC Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RTIF                           : 1;
	BITFIELD RTCLKS                         : 2;
	BITFIELD RTIE                           : 1;
	BITFIELD RTCPS                          : 4;
} _RTC_SC;
#define sRTC_SC          (*(_RTC_SC *) (0x00F320))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RTCCNT                         : 8;
} _RTC_CNT;
#define sRTC_CNT         (*(_RTC_CNT *) (0x00F321))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RTCMOD                         : 8;
} _RTC_MOD;
#define sRTC_MOD         (*(_RTC_MOD *) (0x00F322))


///////////////////////////////////////////////////////////////////////////////////
// HFM Struct Definitions & Register Pointers
///////////////////////////////////////////////////////////////////////////////////
typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD DIVLD                          : 1;
	BITFIELD PRDIV8                         : 1;
	BITFIELD DIV                            : 6;
} _FM_CLKDIV;
#define sFM_CLKDIV       (*(_FM_CLKDIV *) (0x00F400))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD LOCK                           : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD AEIE                           : 1;
	BITFIELD CBEIE                          : 1;
	BITFIELD CCIE                           : 1;
	BITFIELD KEYACC                         : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _FM_CNFG;
#define sFM_CNFG         (*(_FM_CNFG *) (0x00F401))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD DIRECT                         : 1;
} _FM_TEST;
#define sFM_TEST         (*(_FM_TEST *) (0x00F402))

typedef struct {
	BITFIELD KEYEN                          : 1;
	BITFIELD SECSTAT                        : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _FM_SECHI;
#define sFM_SECHI        (*(_FM_SECHI *) (0x00F403))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD SEC                            : 2;
} _FM_SECLO;
#define sFM_SECLO        (*(_FM_SECLO *) (0x00F404))

typedef struct {
	BITFIELD HFMMNTR                        : 16;
} _FM_MONITOR;
#define sFM_MONITOR      (*(_FM_MONITOR *) (0x00F405))

typedef struct {
	BITFIELD PROTECT                        : 16;
} _FM_PROT;
#define sFM_PROT         (*(_FM_PROT *) (0x00F410))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD RESERVED0_2                    : 1;
	BITFIELD FAIL                           : 1;
	BITFIELD DONE                           : 1;
} _FM_TSTAT;
#define sFM_TSTAT        (*(_FM_TSTAT *) (0x00F412))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD CBEIF                          : 1;
	BITFIELD CCIF                           : 1;
	BITFIELD PVIOL                          : 1;
	BITFIELD ACCERR                         : 1;
	BITFIELD RESERVED0_3                    : 1;
	BITFIELD BLANK                          : 1;
	BITFIELD RESERVED0_1                    : 1;
	BITFIELD RESERVED0_0                    : 1;
} _FM_USTAT;
#define sFM_USTAT        (*(_FM_USTAT *) (0x00F413))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD CMD                            : 7;
} _FM_CMD;
#define sFM_CMD          (*(_FM_CMD *) (0x00F414))

typedef struct {
	BITFIELD TMR                            : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD ERASE                          : 1;
	BITFIELD PROG                           : 1;
	BITFIELD IFREN                          : 1;
	BITFIELD NVSTR                          : 1;
	BITFIELD XE                             : 1;
	BITFIELD YE                             : 1;
	BITFIELD SE                             : 1;
	BITFIELD MAS1                           : 1;
} _FM_CONTROL;
#define sFM_CONTROL      (*(_FM_CONTROL *) (0x00F415))

typedef struct {
	BITFIELD HFMADR                         : 16;
} _FM_ADDR;
#define sFM_ADDR         (*(_FM_ADDR *) (0x00F416))

typedef struct {
	BITFIELD HFMDATA                        : 16;
} _FM_DATA;
#define sFM_DATA         (*(_FM_DATA *) (0x00F418))

typedef struct {
	BITFIELD IFR_OPT0                       : 16;
} _FM_OPT0;
#define sFM_OPT0         (*(_FM_OPT0 *) (0x00F41A))

typedef struct {
	BITFIELD IFR_OPT1                       : 16;
} _FM_OPT1;
#define sFM_OPT1         (*(_FM_OPT1 *) (0x00F41B))

typedef struct {
	BITFIELD RESERVED0_15                   : 1;
	BITFIELD RESERVED0_14                   : 1;
	BITFIELD RESERVED0_13                   : 1;
	BITFIELD RESERVED0_12                   : 1;
	BITFIELD RESERVED0_11                   : 1;
	BITFIELD RESERVED0_10                   : 1;
	BITFIELD RESERVED0_9                    : 1;
	BITFIELD RESERVED0_8                    : 1;
	BITFIELD RESERVED0_7                    : 1;
	BITFIELD RESERVED0_6                    : 1;
	BITFIELD RESERVED0_5                    : 1;
	BITFIELD RESERVED0_4                    : 1;
	BITFIELD MEM_SEL                        : 4;
} _FM_MEM_SEL;
#define sFM_MEM_SEL      (*(_FM_MEM_SEL *) (0x00F41C))

typedef struct {
	BITFIELD TST_AREA_SIG                   : 16;
} _FM_TSTSIG;
#define sFM_TSTSIG       (*(_FM_TSTSIG *) (0x00F41D))

#endif // __56f8006_h
